﻿;Generated With PSOL engine
(in-package :psol)
(oli::GEOMETRY_MODE :REAL)

(oli::act_deact_module :act "STEP" "MODULE-CONTROLLER-Interfaces-STEP-TB" '(STARTUP::ACTIVATE-STEP))
(oli::act_deact_module :act "ACIS_SAT" "MODULE-CONTROLLER-Interfaces-ACIS_SAT-TB" '(STARTUP::ACTIVATE-SD-SAT-ADAPTER))
(oli::act_deact_module :act "IGESDEK" "MODULE-CONTROLLER-Interfaces-IGESDEK-TB" '(STARTUP::ACTIVATE-SD-IGESDEK-ADAPTER))


;********** Begin Logging Utilities **********

(defun BeginExportLog()
    (if (not (boundp '*LogLevel*))
        (defparameter *LogLevel* 3)
    )

    (defparameter *ErrorLog*   (list "********** Enter OSDM Export **********"))
    (defparameter *WarningLog* (list "********** Enter OSDM Export **********"))
    (defparameter *DebugLog*   (list "********** Enter OSDM Export **********"))
    (defparameter *TraceLog*   (list "********** Enter OSDM Export **********"))
)

(defun EndExportLog()
    (defparameter *ErrorLog*   (append *ErrorLog*   (list "********** Leave OSDM Export **********")))
    (defparameter *WarningLog* (append *WarningLog* (list "********** Leave OSDM Export **********")))
    (defparameter *DebugLog*   (append *DebugLog*   (list "********** Leave OSDM Export **********")))
    (defparameter *TraceLog*   (append *TraceLog*   (list "********** Leave OSDM Export **********")))
)

(defun DisplayExportLog()

    (if (and (= *LogLevel* 4) (> (length *ErrorLog*) 2))
        (dolist (logEntry *ErrorLog*)
            (oli::display logEntry)
        )
    )
    (if (and (= *LogLevel* 3) (> (length *WarningLog*) 2))
        (dolist (logEntry *WarningLog*)
            (oli::display logEntry)
        )
    )
    (if (and (= *LogLevel* 2) (> (length *DebugLog*) 2))
        (dolist (logEntry *DebugLog*)
            (oli::display logEntry)
        )
    )
    (if (and (= *LogLevel* 1) (> (length *TraceLog*) 2))
        (dolist (logEntry *TraceLog*)
            (oli::display logEntry)
        )
    )
)

(defun Log(level message)
    (if (> level 0)
        (defparameter *TraceLog*   (append *TraceLog* (list message)))
    )

    (if (> level 1)
        (defparameter *DebugLog*   (append *DebugLog* (list message)))
    )

    (if (> level 2)
        (defparameter *WarningLog* (append *WarningLog* (list message)))
    )

    (if (> level 3)
        (defparameter *ErrorLog*   (append *ErrorLog* (list message)))
    )
)

;********** Leave Logging Utilities **********

(defun CreatePSol()

;;;;;********** Begin Reset Global Variables **********

(defparameter *ObjectParentName* "/" "/")
(defparameter *ObjectPathName* "/" "/")
(defparameter *ObjectAsmName* "/" "/")
(defparameter *PartExistsValue* 0)
(defparameter *PartExistsName* nil)
(defparameter *OnOpenValue* 0)
(defparameter *OnOpenName* nil)
(defparameter *OnSaveValue* 0)

;;;;;********** End Reset Global Variables **********


;;;;;********** Begin Global Utilities **********

(defun ReplaceAll (string part replacement &key (test #'char=))
  (with-output-to-string (out)
    (loop with part-length = (length part)
          for old-pos = 0 then (+ pos part-length)
          for pos = (search part string
                            :start2 old-pos
                            :test test)
          do (write-string string out
                           :start old-pos
                           :end (or pos (length string)))
          when pos do (write-string replacement out)
          while pos)
  )
)

(defun Cat-Path-Name(path name)
    (format nil "~A~A" path name)
)

(defun Select-WP(path wp-name)
    (let ((full-solid-name (cat-path-name path wp-name)))
        (oli::current_wp full-solid-name)
    )
)

(defun PartBrowse(selected_part searched_part)
    (defparameter *PartTestName* (oli::sd-inq-obj-contents-name selected_part))

    (if (string= searched_part *PartTestName*)
        (progn
            (defparameter *PartExistsValue* 1)
            (defparameter *PartExistsName* (oli::sd-inq-obj-pathname selected_part))
            (return-from PartBrowse t)
        )
        (progn
            (if (oli::sd-inq-assembly-p selected_part)
                (progn
                    (dolist (i (oli::sd-inq-obj-children selected_part))
                        (PartBrowse i searched_part)
                    )
                )
            )
        )
    )
)

(defun RootBrowse(searched_part)
    (dolist (item (oli::sd-inq-obj-children (oli::sd-pathname-to-obj "/")))
        (if (or (oli::sd-inq-assembly-p item) (oli::sd-inq-part-p item))
            (PartBrowse item searched_part)
        )
    )
)

(defun PartExists (partPathName)
    (defparameter *PartExistsValue* 0)
    (defparameter *PartExistsName* nil)
    (RootBrowse partPathName)
)

(defun transform-document (full_name ox1 oy1 oz1 ox2 oy2 oz2 ox3 oy3 oz3 nx1 ny1 nz1 nx2 ny2 nz2 nx3 ny3 nz3)
    (oli::position_pa full_name 
        :MATCH_THREE_PTS
        (oli::make-gpnt3d :x ox1 :y oy1 :z oz1) (oli::make-gpnt3d :x nx1 :y ny1 :z nz1)
        (oli::make-gpnt3d :x ox2 :y oy2 :z oz2) (oli::make-gpnt3d :x nx2 :y ny2 :z nz2)
        (oli::make-gpnt3d :x ox3 :y oy3 :z oz3) (oli::make-gpnt3d :x nx3 :y ny3 :z nz3)
    )
)

(defun TransformPosition(matXVec matYVec matZVec matTVec position)
	(let 
		(
			(x (+ (* (oli::gpnt3d_x matXVec) (oli::gpnt3d_x position)) (* (oli::gpnt3d_x matYVec) (oli::gpnt3d_y position)) (* (oli::gpnt3d_x matZVec) (oli::gpnt3d_z position)) (oli::gpnt3d_x matTVec)))
			(y (+ (* (oli::gpnt3d_y matXVec) (oli::gpnt3d_x position)) (* (oli::gpnt3d_y matYVec) (oli::gpnt3d_y position)) (* (oli::gpnt3d_y matZVec) (oli::gpnt3d_z position)) (oli::gpnt3d_y matTVec)))
			(z (+ (* (oli::gpnt3d_z matXVec) (oli::gpnt3d_x position)) (* (oli::gpnt3d_z matYVec) (oli::gpnt3d_y position)) (* (oli::gpnt3d_z matZVec) (oli::gpnt3d_z position)) (oli::gpnt3d_z matTVec)))
		)
		(return-from TransformPosition (oli::make-gpnt3d :x x :y y :z z))
	)
)

(defun TransformDirection(matXVec matYVec matZVec matTVec position)
	(let 
		(
			(x (+ (* (oli::gpnt3d_x matXVec) (oli::gpnt3d_x position)) (* (oli::gpnt3d_x matYVec) (oli::gpnt3d_y position)) (* (oli::gpnt3d_x matZVec) (oli::gpnt3d_z position))))
			(y (+ (* (oli::gpnt3d_y matXVec) (oli::gpnt3d_x position)) (* (oli::gpnt3d_y matYVec) (oli::gpnt3d_y position)) (* (oli::gpnt3d_y matZVec) (oli::gpnt3d_z position))))
			(z (+ (* (oli::gpnt3d_z matXVec) (oli::gpnt3d_x position)) (* (oli::gpnt3d_z matYVec) (oli::gpnt3d_y position)) (* (oli::gpnt3d_z matZVec) (oli::gpnt3d_z position))))
		)
		(return-from TransformDirection (oli::make-gpnt3d :x x :y y :z z))
	)
)

(defun DecodeEmbeddedData(data)
    (let
        (
            (max (- (length data) 1))
            (ret "")
        )
        (do ((i 0 (+ i 1))) ((> i max) (return-from DecodeEmbeddedData ret))
            (progn
                (if (= (char-code (aref data i)) (char-code #\\))
                    (progn
                        (setf ret (format nil "~A~A" ret (aref data (+ i 1)) ))
                        (setf i (+ i 1))
                    )
                    (progn
                        (setf ret (format nil "~A~A" ret (aref data i) ))
                    )
                )
            )
        )
    )
)

;;;;;********** End Global Utilities **********


;;;;;********** Begin Geometry Utilities ***********

(defun CreateEmptySketch(ownerPath sketchName tVec xVec yVec)
	(oli::create_workplane :new :owner ownerPath :name sketchName :pt_pt_pt tVec (oli::sd-vec-add tVec xVec) (oli::sd-vec-add tVec yVec))
)

(defun CreateSketchCircle(x y r)
    (oli::circle :cen_rad (oli::make-gpnt2d :x x :y y) r)
)

(defun CreateSketchLine(x1 y1 x2 y2)
    (oli::line :two_points (oli::make-gpnt2d :x x1 :y y1) (oli::make-gpnt2d :x x2 :y y2))
)

(defun CreateSketchArc3Points(x1 y1 x2 y2 x3 y3)
    (oli::arc :3_pos
        (oli::make-gpnt2d :x x1 :y y1)
        (oli::make-gpnt2d :x x3 :y y3)
        (oli::make-gpnt2d :x x2 :y y2)
    )
)

(defun CreateExtrudeBase(targetPath sketchName length side)
    (select-wp "/" sketchName)
    (oli::extrude :auto_direction :yes
        :sel_part targetPath
	     :wp (oli::sd-inq-obj-pathname (oli::sd-inq-curr-wp))
	     :distance_type :distance length
	     :direction side
	     :keep_profile :no
	     :keep_wp :no
    )
)

(defun CreateExtrudeBaseAngle(targetPath sketchName length side angle)
    (setq angle (oli::sd-deg-to-rad angle))
    (select-wp "/" sketchName)
    (oli::extrude :auto_direction :yes
        :sel_part targetPath
	     :wp (oli::sd-inq-obj-pathname (oli::sd-inq-curr-wp))
	     :distance_type :distance length
	     :direction side
	     :draft_angle :on
	     :draft_angle angle
	     :keep_profile :no
	     :keep_wp :no
    )
)

(defun CreateExtrudeCut(targetPath sketchName length side)
    (select-wp "/" sketchName)
    (oli::mill :auto_direction :yes
        :sel_part targetPath
	     :wp (oli::sd-inq-obj-pathname (oli::sd-inq-curr-wp))
	     :distance_type :distance length
	     :direction side
	     :keep_profile :no
	     :keep_wp :no
    )
)

(defun CreateExtrudeCutAngle(targetPath sketchName length side angle)
    (setq angle (oli::sd-deg-to-rad angle))
    (select-wp "/" sketchName)
    (oli::mill :auto_direction :yes
        :sel_part targetPath
	     :wp (oli::sd-inq-obj-pathname (oli::sd-inq-curr-wp))
	     :distance_type :distance length
	     :direction side
	     :draft_angle :on
	     :draft_angle angle
	     :keep_profile :no
	     :keep_wp :no
    )
)

(defun CreateRevolveBase(targetPath sketchName clStart clEnd angle side)
    (setq angle (oli::sd-deg-to-rad angle))
    (select-wp "/" sketchName)
    (case side
        (:+W
            (oli::turn :axis
                :two_pta clStart clEnd
                :sel_part targetPath
                :wp (oli::sd-inq-obj-pathname (oli::sd-inq-curr-wp))
                :keep_profile :no
                :keep_wp :no
                :rotation_angle angle
            )
        )
        (:-W
            (oli::turn :axis
                :two_pta clStart clEnd
                :sel_part targetPath
                :wp (oli::sd-inq-obj-pathname (oli::sd-inq-curr-wp))
                :keep_profile :no
                :keep_wp :no
                :rotation_angle (- angle)
            )
        )
        (:BOTH_SIDES
            (oli::turn :axis
                :two_pta clStart clEnd
                :sel_part targetPath
                :wp (oli::sd-inq-obj-pathname (oli::sd-inq-curr-wp))
                :keep_profile :yes
                :keep_wp :yes
                :keep_wp :yes
                :rotation_angle angle
            )
            (oli::turn :axis
                :two_pta clStart clEnd
                :sel_part targetPath
                :wp (oli::sd-inq-obj-pathname (oli::sd-inq-curr-wp))
                :keep_profile :no
                :keep_wp :no
                :rotation_angle (- angle)
            )

            (let (tempPart)
                (setf tempPart (concatenate 'string targetPath ".1"))

                (if (oli::sd-pathname-to-obj tempPart)
                    (oli::unite_3d :blank (oli::sd-pathname-to-obj targetPath) :tools tempPart :keep_tools :no)
                )
            )
        )
    )
)

(defun CreateRevolveCut(targetPath sketchName clStart clEnd angle side)
    (setq angle (oli::sd-deg-to-rad angle))
    (select-wp "/" sketchName)
    (case side
        (:+W
            (oli::bore :axis
                :two_pta clStart clEnd
                :sel_part targetPath
                :wp (oli::sd-inq-obj-pathname (oli::sd-inq-curr-wp))
                :keep_profile :no
                :keep_wp :no
                :rotation_angle angle
            )
        )
        (:-W
            (oli::bore :axis
                :two_pta clStart clEnd
                :sel_part targetPath
                :wp (oli::sd-inq-obj-pathname (oli::sd-inq-curr-wp))
                :keep_profile :no
                :keep_wp :no
                :rotation_angle (- angle)
            )
        )
        (:BOTH_SIDES
            (oli::bore :axis
                :two_pta clStart clEnd
                :sel_part targetPath
                :wp (oli::sd-inq-obj-pathname (oli::sd-inq-curr-wp))
                :keep_profile :yes
                :keep_wp :yes
                :rotation_angle angle
            )
            (oli::bore :axis
                :two_pta clStart clEnd
                :sel_part targetPath
                :wp (oli::sd-inq-obj-pathname (oli::sd-inq-curr-wp))
                :keep_profile :no
                :keep_wp :no
                :rotation_angle (- angle)
            )
        )
    )
)

;;;;;********** End Geometry Utilities **********


;;;;;*********** Begin Load/Store ************

(defun OpenFile(fileName)
    ;(display (format nil "OpenFile ~A" fileName))

    (if (oli::sd-inq-file-status fileName :read-access)
        (progn
            (oli::universal_load :file fileName)
            (oli::display :hide)
            (return-from OpenFile t)
        )
    )

    (return-from OpenFile nil)
)

(defun SaveFile(objectName fileName overwriteNeeded)
    ;(display (format nil "SaveFile ~A ~A ~A" objectName fileName overwriteNeeded))

    (if (oli::sd-inq-file-status fileName :existing)
        (return-from SaveFile nil)
    )

    (let ( (obj (oli::sd-pathname-to-obj objectName)))
        (if (not (null obj))
            (if (= overwriteNeeded 1)
                (oli::save_package :objects objectName :filename fileName :overwrite)
                (oli::save_package :objects objectName :filename fileName)
            )
        )
    )

    (return-from SaveFile t)
)

(defun OpenSDPC(sourcePath fileName)
    ;(display (format nil "OpenSDPC ~A ~A" sourcePath fileName))

    (let ((wd (oli::sd-get-current-working-directory)))
        (oli::cd sourcePath)

        (if (oli::sd-inq-file-status fileName :read-access)
            (progn
                (oli::load_sd fileName)
                (oli::display :hide)
                (oli::cd wd)
                (return-from OpenSDPC t)
            )
            (progn
                (oli::cd wd)
                (return-from OpenSDPC nil)
            )
        )
    )
)

(defun SaveSDPC(objectName targetPath instanceFileName)
    ;(display (format nil "SaveSDPC ~A ~A ~A" objectName targetPath instanceFileName))

    (let (
            (obj (oli::sd-pathname-to-obj objectName))
            (wd (oli::sd-get-current-working-directory))
            (parentPath nil)
            (baseName nil)
        )

        (setf baseName (oli::sd-inq-obj-basename obj))

        (if (oli::sd-inq-parent-obj obj)
            (setf parentPath (oli::sd-inq-obj-pathname (oli::sd-inq-parent-obj obj)))
            (setf parentPath "/")
        )

        (if (not (string= "/" parentPath))
	        (oli::change_pa_owner :new_owner "/" :parts_assemblies obj)
        )

        (oli::cd targetPath)
        (oli::save_sd_modified :cwd_changed (concatenate 'string "/" baseName) :display-instances :change_instance_file 0 instanceFileName :undisplay-instances :directory targetPath)
        (oli::cd wd)

        (if (not (string= "/" parentPath))
            (oli::change_pa_owner :new_owner parentPath :parts_assemblies (oli::sd-pathname-to-obj (concatenate 'string "/" baseName)))
        )
    )
    (return-from SaveSDPC t)
)

(defun GetAllTopLevelObjects()
    (return-from GetAllTopLevelObjects (oli::sd-inq-obj-children (oli::sd-pathname-to-obj "/")))
)

(defun LoadSATFile(fileName modelName parentPath)
    ;(display "Enter LoadSATFile")

	(let (lastActivePart lastActiveWP topLevelItemsBefore topLevelItemsAfter i namesBefore namesAfter)
		(setf lastActivePart (oli::sd-inq-curr-part))
		(setf lastActiveWP (oli::sd-inq-curr-wp))

		;Store #TopLevelParts and #TopLevelAssemblies before import
		(setf topLevelItemsBefore (psol::GetAllTopLevelObjects))

		(dolist (item topLevelItemsBefore)
			(setf namesBefore (cons (oli::sd-inq-obj-pathname item) namesBefore))
		)

		;Do the import
		(oli::native_cad_in :cad_system :acis_sat :FILENAME filename)

		;Store #TopLevelParts and #TopLevelAssemblies after import
		(setf topLevelItemsAfter (psol::GetAllTopLevelObjects))

		(dolist (item topLevelItemsAfter)
			(setf namesAfter (cons (oli::sd-inq-obj-pathname item) namesAfter))
		)

		;Create a container for the imported file
		(oli::create_container :name modelname :model_name modelname :owner "/")

		;Move the imported items into the container
		(setf i 0)
		(let (found)
			(dolist (nameAfter namesAfter)
				(setf found nil)

				(dolist (nameBefore namesBefore)
					(if (string= nameBefore nameAfter)
						(setf found t)
					)
				)

				(if (not found)
                   (progn
                       (let
                           (
                               (subModelName (format nil "~A~A~A" modelname "_MODEL_" i))
                               (subModelPath (concatenate 'string "/" modelName "/" (format nil "~A~A~A" modelname "_MODEL_" i)))
                               (j 0)
                           )
                           (oli::change_name_pa :part_asmb (oli::sd-pathname-to-obj nameAfter) :name subModelName :model_name subModelName)
                           (oli::change_pa_owner :new_owner (concatenate 'string "/" modelName) :parts_assemblies (oli::sd-pathname-to-obj (concatenate 'string "/" subModelName)))

                           (if (oli::sd-inq-assembly-p (oli::sd-pathname-to-obj subModelPath))
                               (progn
                                   (dolist (child (oli::sd-inq-obj-children (oli::sd-pathname-to-obj subModelPath)))
                                       (oli::change_name_pa :part_asmb child :name (format nil "~A~A~A" subModelName "_COMP_" j))
                                       (setf j (+ j 1))
                                   )
                               )
                           )

				            (setf i (+ i 1))
                       )
                   )
				)

			)
		)

		;Move the container to right position
		(if (not (string= parentPath "/"))
			(oli::change_pa_owner :new_owner parentPath :parts_assemblies (concatenate 'string "/" modelName))
		)

		(if (not (null lastActiveWP))
			(oli::current_wp lastActiveWP)
		)

		(if (not (null lastActivePart))
			(oli::current_part lastActivePart)
		)

		(oli::display :hide)
	)
)

(defun LoadIGESFile(fileName modelName parentPath)
    ;(display "Enter LoadIGESFile")

	(let (lastActivePart lastActiveWP topLevelItemsBefore topLevelItemsAfter namesBefore namesAfter i)
		(setf lastActivePart (oli::sd-inq-curr-part))
		(setf lastActiveWP (oli::sd-inq-curr-wp))

		;Store #TopLevelParts and #TopLevelAssemblies before import
		(setf topLevelItemsBefore (psol::GetAllTopLevelObjects))

		(dolist (item topLevelItemsBefore)
			(setf namesBefore (cons (oli::sd-inq-obj-pathname item) namesBefore))
		)

		;Do the import
		(oli::native_cad_in :cad_system :igesdek :filename fileName)

		;Store #TopLevelParts and #TopLevelAssemblies after import
		(setf topLevelItemsAfter (psol::GetAllTopLevelObjects))

		(dolist (item topLevelItemsAfter)
			(setf namesAfter (cons (oli::sd-inq-obj-pathname item) namesAfter))
		)

		;Create a container for the imported file
		(oli::create_container :name modelname :model_name modelname :owner "/")

		;Move the imported items into the container
		(setf i 0)
		(let (found)
			(dolist (nameAfter namesAfter)
				(setf found nil)

				(dolist (nameBefore namesBefore)
					(if (string= nameBefore nameAfter)
						(setf found t)
					)
				)

				(if (not found)
                   (progn
                       (let
                           (
                               (subModelName (format nil "~A~A~A" modelname "_MODEL_" i))
                               (subModelPath (concatenate 'string "/" modelName "/" (format nil "~A~A~A" modelname "_MODEL_" i)))
                               (j 0)
                           )
                           (oli::change_name_pa :part_asmb (oli::sd-pathname-to-obj nameAfter) :name subModelName :model_name subModelName)
                           (oli::change_pa_owner :new_owner (concatenate 'string "/" modelName) :parts_assemblies (oli::sd-pathname-to-obj (concatenate 'string "/" subModelName)))

                           (if (oli::sd-inq-assembly-p (oli::sd-pathname-to-obj subModelPath))
                               (progn
                                   (dolist (child (oli::sd-inq-obj-children (oli::sd-pathname-to-obj subModelPath)))
                                       (oli::change_name_pa :part_asmb child :name (format nil "~A~A~A" subModelName "_COMP_" j))
                                       (setf j (+ j 1))
                                   )
                               )
                           )

				            (setf i (+ i 1))
                       )
                   )
				)

			)
		)

		;Move the container to right position
		(if (not (string= parentPath "/"))
			(oli::change_pa_owner :new_owner parentPath :parts_assemblies (concatenate 'string "/" modelName))
		)

		(if (not (null lastActiveWP))
			(oli::current_wp lastActiveWP)
		)

		(if (not (null lastActivePart))
			(oli::current_part lastActivePart)
		)

		(oli::display :hide)
	)
)

(defun LoadSTEPFile(fileName modelName parentPath)
    ;(display "Enter LoadStepFile")

	(let (lastActivePart lastActiveWP topLevelItemsBefore topLevelItemsAfter namesBefore namesAfter i)
		(setf lastActivePart (oli::sd-inq-curr-part))
		(setf lastActiveWP (oli::sd-inq-curr-wp))

		;Store #TopLevelParts and #TopLevelAssemblies before import
		(setf topLevelItemsBefore (psol::GetAllTopLevelObjects))

		(dolist (item topLevelItemsBefore)
			(setf namesBefore (cons (oli::sd-inq-obj-pathname item) namesBefore))
		)

		;Do the import
		(oli::step_import :filename fileName)

		;Store #TopLevelParts and #TopLevelAssemblies after import
		(setf topLevelItemsAfter (psol::GetAllTopLevelObjects))

		(dolist (item topLevelItemsAfter)
			(setf namesAfter (cons (oli::sd-inq-obj-pathname item) namesAfter))
		)

		(let (found)
			(dolist (nameAfter namesAfter)
				(setf found nil)

				(dolist (nameBefore namesBefore)
					(if (string= nameBefore nameAfter)
						(setf found t)
					)
				)

				(if (not found)
					(progn
						(dolist (item (oli::sd-inq-obj-children (oli::sd-pathname-to-obj nameAfter)))
							(oli::unite_3d :keep_tools :no :blank parentPath :tools item)
						)

						(oli::delete_3d nameAfter)
					)
				)
			)
		)

		(if (not (null lastActiveWP))
			(oli::current_wp lastActiveWP)
		)

		(if (not (null lastActivePart))
			(oli::current_part lastActivePart)
		)

		(oli::display :hide)
	)
)

;;;;;*********** End Load/Store ***********


(defun HasGeometry(obj)
    (if (oli::sd-inq-part-p obj)
        (return-from HasGeometry (not (oli::sd-inq-empty-part-p obj)))
    )

    (let
         (
              (children (oli::sd-inq-obj-children obj))
         )
         (dolist (child children)
             (if (HasGeometry child)
                 (return-from HasGeometry t)
             )
         )
         (return-from HasGeometry nil)
    )
)

(defun Hilite(model)
	(oli::add_to_vp_drawlist (oli::sd-inq-current-vp) :no-hilite model)

	(let
		(
			(children (oli::sd-inq-obj-children model))
		)
	
        (dolist (child children)
            (Hilite child)
        )
	)
)


    (Log 2 (concatenate 'string "Calling Callback " "AppBeforeCreate"))
    
    (Log 2 (concatenate 'string "Called Callback " "AppBeforeCreate"))



;;;;;*********** Enter Save Old Actives **********

(defparameter *ActiveWorkplane* (oli::sd-inq-curr-wp))
(defparameter *ActivePart* (oli::sd-inq-curr-part))

;;;;;*********** Leave Save Old Actives **********

(defun CreateNewAssembly_1001()
    (Log 1 "Enter CreateNewAssembly_1001")

    (defparameter *ObjectAsmName* "H2LV_28L_300_T010E")
    (GenerateObject_1001)

    (Log 1 "Leave CreateNewAssembly_1001")
    (return-from CreateNewAssembly_1001 t)
)

(defun BuildAssembly_1001()
    (Log 1 "Enter BuildAssembly_1001")
    (Log 2 "Assembly Name: H2LV_28L_300_T010E")
    (Log 2 "Pool Path:     \\10.0.0.236\data_v9/pool/onespacemodeller/")
    (Log 2 "File Name:     H2LV_28L_300_T010E")
    (Log 2 "Display Name:  H2LV_28L_300_T010E")
    (Log 2 "ObjectPath:    /H2LV_28L_300_T010E")

    (OnOpen_1001)

    (if (= *OnOpenValue* 1)
        (progn
            (Log 2 "Loaded Assembly From Session After OnOpen")
            (Log 1 "Leave BuildAssembly_1001")
            (return-from BuildAssembly_1001 t)
        )
    )

	 (if (not (CreateNewAssembly_1001))
		 (progn
			  (Log 4 "Assembly Creation Failed")
             (Log 1 "Leave BuildAssembly_1001")
			  (return-from BuildAssembly_1001 nil)
		 )
        (progn
            (Log 2 "Assembly Creation Succeeded")
        )
	 )

	 (beforesave_1001)
	 (onsave_1001)
	 (aftersave_1001)

    (Log 1 "Leave BuildAssembly_1001")
	 (return-from BuildAssembly_1001 t)
)

(defun onopen_1001()
    (Log 2 (concatenate 'string "Calling Callback " "DocOnOpen"))
        (Log 2 "Enter Callback SessionAssemblyOnOpen")
    (Log 2 "Content Name:      H2LV_28L_300_T010E")

    (defparameter *OnOpenValue* 0)
    (defparameter *OnOpenName* nil)

    (let
        (
            (fileName "H2LV_28L_300_T010E")
            (displayName (oli::sd-gen-obj-basename :part :parent *ObjectParentName* :prefix "H2LV_28L_300_T010E."))
        )
        (PartExists "H2LV_28L_300_T010E")

        (if (not (= *PartExistsValue* 0))
            (progn
                (Log 2 (concatenate 'string "Found Content At:  " *PartExistsName*))

                (oli::create_MULTIPLE_PA :share :owner *ObjectParentName* :name displayName :source *PartExistsName*)

                (defparameter *OnOpenValue* 1)
                (defparameter *OnOpenName* (concatenate 'string *ObjectParentName* "/" displayName))
                (defparameter *ObjectPathName* *OnOpenName*)
                (Log 2 (concatenate 'string "New Instance Path: " *ObjectPathName*))
            )
            (progn
                (Log 2 "Content Not Found In Session")
            )
        )
    )

    (Log 2 "Leave Callback SessionAssemblyOnOpen")
    (Log 2 (concatenate 'string "Called Callback " "DocOnOpen"))
)

(defun beforecreate_1001()
    (Log 2 (concatenate 'string "Calling Callback " "DocBeforeCreate"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocBeforeCreate"))
)

(defun aftercreate_1001()
    (Log 2 (concatenate 'string "Calling Callback " "DocAfterCreate"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocAfterCreate"))
)

(defun beforesave_1001()
    (Log 2 (concatenate 'string "Calling Callback " "DocBeforeSave"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocBeforeSave"))
)

(defun onsave_1001()
    (Log 2 (concatenate 'string "Calling Callback " "DocOnSave"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocOnSave"))
)

(defun aftersave_1001()
    (Log 2 (concatenate 'string "Calling Callback " "DocAfterSave"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocAfterSave"))
)

(defun GenerateObject_1001()
    (oli::create_assembly :owner "/" :name *ObjectAsmName*)
    (defparameter *ObjectParentName* (concatenate 'string "/" *ObjectAsmName*))
    (defparameter *ObjectPathName* (concatenate 'string *ObjectParentName*))
    (Log 1 "Enter GenerateObject_1001")
    (beforecreate_1001)
    (oli::sd-attach-item-attribute (oli::sd-pathname-to-obj (concatenate 'string *ObjectParentName*)) "PARTsolutions-attribute" :attachment :contents :on-copy :copy :on-xform :maintain :values '("mident" "{$CADENAS_DATA%5C23d-libs%5Cnissei%5Cproducts_jp%5Cinduction_g_m%5Cgtr_midi_01kw_22kw%5Cstandard_gm%5Cwaterproof_gm%5Cright_angle_shaft_h2_series%5Cwrgmss_l_shaft%5Ch2_water_resistant_gearmotor_wsus_l_l_asmtab.prj}%2C200%20{VTYP=3D}%2C{STYP=ASSTAB}%2C{NB=H2LV-28L-300-T010E}%2C{LINA=H2LV-28L-300-T010E}%2C{NN=Foot%20mount}%2C{DATE=23.04.2015%2008:59:39}%2C{GEOMDATE=23.04.2015%2008:59:37}%2C{VERSION=}%2C{LINEID=590}%2C{LINESUBID=-1}%2C{WBVAR=PTB}%20%20{NB=H2LV-28L-300-T010E}%2C{LINA=H2LV-28L-300-T010E}%2C{KT=DUMMY}%2C{TREE=L}%2C{VT=3-Phase%20200V}%2C{VVIS=3-Phase%20200V}%2C{INFO=Infotext}%2C{MCT=0.1kW}%2C{MCVIS=0.1kW}%2C{MC1=%27T010%27%2C%270.1kW%27%2C%27T020%27%2C%270.2kW%27%2C%27T040%27%2C%270.4kW%27%2C%27075%27%2C%270.75kW%27%2C%27150%27%2C%271.5kW%27%2C%27220%27%2C%272.2kW%27}%2C{MC2=%27T010%27%2C%270.1kW%27%2C%27T020%27%2C%270.2kW%27%2C%27T040%27%2C%270.4kW%27%2C%27075%27%2C%270.75kW%27%2C%27150%27%2C%271.5kW%27%2C%27220%27%2C%272.2kW%27}%2C{MC3=%27T010%27%2C%270.1kW%27%2C%27T020%27%2C%270.2kW%27%2C%27T040%27%2C%270.4kW%27%2C%27075%27%2C%270.75kW%27%2C%27150%27%2C%271.5kW%27%2C%27220%27%2C%272.2kW%27}%2C{BT=Yes}%2C{BVIS=Yes}%2C{B1=V}%2C{B2=%27No%27%2C%27No%27%2C%27Yes%27%2C%27Yes%27}%2C{B3=%27No%27%2C%27No%27}%2C{B4=%27No%27%2C%27No%27%2C%27Yes%27%2C%27Yes%27}%2C{RT=1/300}%2C{RVIS=1/300}%2C{OSH=28}%2C{OSH1=28}%2C{TB=E}%2C{PTB=}%2C{R1=5%2C%271/5%27%2C10%2C%271/10%27%2C15%2C%271/15%27%2C20%2C%271/20%27%2C25%2C%271/25%27%2C30%2C%271/30%27%2C40%2C%271/40%27%2C50%2C%271/50%27%2C60%2C%271/60%27%2C80%2C%271/80%27%2C100%2C%271/100%27%2C120%2C%271/120%27%2C160%2C%271/160%27%2C200%2C%271/200%27%2C240%2C%271/240%27%2C300%2C%271/300%27%2C375%2C%271/375%27%2C450%2C%271/450%27%2C600%2C%271/600%27%2C750%2C%271/750%27%2C900%2C%271/900%27%2C1200%2C%271/1200%27%2C1500%2C%271/1500%27}%2C{R2=5%2C%271/5%27%2C10%2C%271/10%27%2C15%2C%271/15%27%2C20%2C%271/20%27%2C25%2C%271/25%27%2C30%2C%271/30%27%2C40%2C%271/40%27%2C50%2C%271/50%27%2C60%2C%271/60%27%2C80%2C%271/80%27%2C100%2C%271/100%27%2C120%2C%271/120%27%2C160%2C%271/160%27%2C200%2C%271/200%27%2C240%2C%271/240%27%2C300%2C%271/300%27%2C375%2C%271/375%27%2C450%2C%271/450%27}%2C{R3=5%2C%271/5%27%2C10%2C%271/10%27%2C15%2C%271/15%27%2C20%2C%271/20%27%2C25%2C%271/25%27%2C30%2C%271/30%27%2C40%2C%271/40%27%2C50%2C%271/50%27%2C60%2C%271/60%27%2C80%2C%271/80%27%2C100%2C%271/100%27%2C120%2C%271/120%27}%2C{R4=5%2C%271/5%27%2C10%2C%271/10%27%2C15%2C%271/15%27%2C20%2C%271/20%27%2C25%2C%271/25%27%2C30%2C%271/30%27%2C40%2C%271/40%27%2C50%2C%271/50%27%2C60%2C%271/60%27}%2C{R5=5%2C%271/5%27%2C10%2C%271/10%27%2C15%2C%271/15%27%2C20%2C%271/20%27%2C25%2C%271/25%27%2C30%2C%271/30%27%2C40%2C%271/40%27%2C50%2C%271/50%27%2C60%2C%271/60%27%2C80%2C%271/80%27%2C100%2C%271/100%27%2C120%2C%271/120%27%2C160%2C%271/160%27%2C200%2C%271/200%27%2C240%2C%271/240%27}%2C{R6=5%2C%271/5%27%2C10%2C%271/10%27%2C15%2C%271/15%27%2C20%2C%271/20%27%2C25%2C%271/25%27%2C30%2C%271/30%27%2C40%2C%271/40%27%2C50%2C%271/50%27%2C60%2C%271/60%27%2C80%2C%271/80%27%2C100%2C%271/100%27%2C120%2C%271/120%27%2C160%2C%271/160%27%2C200%2C%271/200%27%2C240%2C%271/240%27%2C300%2C%271/300%27%2C375%2C%271/375%27%2C450%2C%271/450%27%2C600%2C%271/600%27%2C750%2C%271/750%27%2C900%2C%271/900%27%2C1200%2C%271/1200%27%2C1500%2C%271/1500%27}%2C{PTB1=%27%27%2C%27Standard%27%2C%27XH6%27%2C%27H6%27%2C%27XH3%27%2C%27H3%27%2C%27XHZ%27%2C%27HZ%27%2C%27XTZ%27%2C%27TZ%27%2C%27XTZH6%27%2C%27TZH6%27%2C%27XTZH3%27%2C%27TZH3%27%2C%27XTZHZ%27%2C%27TZHZ%27%2C%27XT9%27%2C%27T9%27%2C%27XT9H6%27%2C%27T9H6%27%2C%27XT9H3%27%2C%27T9H3%27%2C%27XT9HZ%27%2C%27T9HZ%27%2C%27XT6%27%2C%27T6%27%2C%20%27XT6H6%27%2C%27T6H6%27%2C%27XT6H3%27%2C%27T6H3%27%2C%27XT6HZ%27%2C%27T6HZ%27%20}%2C{PTB2=%27%27%2C%27Standard%27%2C%27XTZ%27%2C%27TZ%27%2C%27XT9%27%2C%27T9%27%2C%27XT6%27%2C%27T6%27}%2C{PTB3=%27%27%2C%27Standard%27%2C%27XH6%27%2C%27H6%27%2C%27XH3%27%2C%27H3%27%2C%27XHZ%27%2C%27HZ%27%2C%27XTZ%27%2C%27TZ%27%2C%27XTZH6%27%2C%27TZH6%27%2C%27XTZH3%27%2C%27TZH3%27%2C%27XTZHZ%27%2C%27TZHZ%27%2C%27XT9%27%2C%27T9%27%2C%27XT9H6%27%2C%27T9H6%27%2C%27XT9H3%27%2C%27T9H3%27%2C%27XT9HZ%27%2C%27T9HZ%27%2C%27XT6%27%2C%27T6%27%2C%20%27XT6H6%27%2C%27T6H6%27%2C%27XT6H3%27%2C%27T6H3%27%2C%27XT6HZ%27%2C%27T6HZ%27%20}%2C{TBX=E}%2C{TI=E}%2C{PPATH=h2_water_resistant_gearmotor_wsus_l_asmtpl.prj}%2C{INFO1=Infotext}%2C{TREE2=L}%2C{CNSORDERNO=H2LV-28L-300-T010E}%2C{V=}%2C{MC=T010}%2C{B=Yes}%2C{R=300}") :set-modified nil :check-read-only nil)

        (oli::sd-attach-item-attribute (oli::sd-pathname-to-obj (concatenate 'string *ObjectParentName*))  "DEFAULTATTR" :attachment :contents :on-copy :copy :on-xform :maintain :set-modified nil :check-read-only nil  :values '("NN" "Foot mount" "NB" "H2LV-28L-300-T010E" "NBSYN" "H2$TREE.$B1.-$OSH.$TREE2.-$R.-$MC.$V.$TB.$PTB." "LINA" "H2LV-28L-300-T010E" "VT" "3-Phase 200V" "INFO" "Infotext" "MCT" "0.1kW" "BT" "Yes" "RT" "1/300" "OSH" "28" "TB" "E" "PTB" "Standard" "INFO1" "Infotext" "CNSORDERNO" "H2LV-28L-300-T010E" "SUPPLIER" "NISSEI" "ARTICLENO" "H2LV-28L-300-T010E" "BOMINFO" "H2LV-28L-300-T010E" "CREATOR" "CADENAS GmbH" ))


(let ((volTotal 0) (surfaceTotal 0) (massTotal 0))
    (let ((SAVEPARENT *ObjectParentName*) (SAVEASM *ObjectAsmName*) (SAVEPATH *ObjectPathName*))
(defun onopen_1()
    (Log 2 (concatenate 'string "Calling Callback " "DocOnOpen"))
        (Log 2 "Enter Callback SessionPartOnOpen")
    (Log 2 "Content Name:      HL28L2")

    (defparameter *OnOpenValue* 0)
    (defparameter *OnOpenName* nil)

    (let
        (
            (fileName "HL28L2")
            (displayName (oli::sd-gen-obj-basename :part :parent *ObjectParentName* :prefix "HL28L2."))
        )
        (PartExists "HL28L2")

        (if (not (= *PartExistsValue* 0))
            (progn
                (Log 2 (concatenate 'string "Found Content At:  " *PartExistsName*))

                (oli::create_MULTIPLE_PA :share :owner *ObjectParentName* :name displayName :source *PartExistsName*)

                (let (tVec xVec zVec tx ty tz xx xy xz zx zy zz)
                   (setf tVec (oli::sd-vec-xform 0,0,0 :source-space (oli::sd-inq-curr-part) :dest-space :global))
                   (setf xVec (oli::sd-vec-xform 1,0,0 :source-space (oli::sd-inq-curr-part) :dest-space :global))
                   (setf zVec (oli::sd-vec-xform 0,0,1 :source-space (oli::sd-inq-curr-part) :dest-space :global))

                   (setf tx   (oli::gpnt3d_x tVec))
                   (setf ty   (oli::gpnt3d_y tVec))
                   (setf tz   (oli::gpnt3d_z tVec))

                   (setf xx   (oli::gpnt3d_x xVec))
                   (setf xy   (oli::gpnt3d_y xVec))
                   (setf xz   (oli::gpnt3d_z xVec))

                   (setf zx   (oli::gpnt3d_x zVec))
                   (setf zy   (oli::gpnt3d_y zVec))
                   (setf zz   (oli::gpnt3d_z zVec))

                   (transform-document (oli::sd-inq-curr-part) tx ty tz xx xy xz zx zy zz 0 0 0 1 0 0 0 0 1)
                )

                (defparameter *OnOpenValue* 1)
                (defparameter *OnOpenName* (concatenate 'string *ObjectParentName* "/" displayName))
                (defparameter *ObjectPathName* *OnOpenName*)
                (Log 2 (concatenate 'string "New Instance Path: " *ObjectPathName*))
            )
            (progn
                (Log 2 "Content Not Found In Session")
            )
        )
    )

    (Log 2 "Leave Callback SessionPartOnOpen")
    (Log 2 (concatenate 'string "Called Callback " "DocOnOpen"))
)

(defun beforecreate_1()
    (Log 2 (concatenate 'string "Calling Callback " "DocBeforeCreate"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocBeforeCreate"))
)

(defun aftercreate_1()
    (Log 2 (concatenate 'string "Calling Callback " "DocAfterCreate"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocAfterCreate"))
)

(defun beforesave_1()
    (Log 2 (concatenate 'string "Calling Callback " "DocBeforeSave"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocBeforeSave"))
)

(defun onsave_1()
    (Log 2 (concatenate 'string "Calling Callback " "DocOnSave"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocOnSave"))
)

(defun aftersave_1()
    (Log 2 (concatenate 'string "Calling Callback " "DocAfterSave"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocAfterSave"))
)

(defun GenerateObject_1()
    (Log 1 "Enter GenerateObject_1")

    ;;;;;********** Enter CreatePart **********

    (defparameter *ObjectPartName* "HL28L2" "HL28L2")

    (if (string= *ObjectParentName* "/")
        (defparameter *ObjectPathName* (concatenate 'string *ObjectParentName* *ObjectPartName*))
        (defparameter *ObjectPathName* (concatenate 'string *ObjectParentName* "/" *ObjectPartName*))
    )

    (progn
        (oli::create_part :owner *ObjectParentName* :name *ObjectPartName*)
        (defparameter *ObjectPartName* "HL28L2")
        (defparameter *ObjectPartModelName* "HL28L2")
        (oli::change_name_pa :part_asmb *ObjectPathName* :name *ObjectPartModelName* :model_name *ObjectPartName*)
        (defparameter *ObjectPathName* (concatenate 'string *ObjectParentName* "/" *ObjectPartModelName*))

        (beforecreate_1)

        ;;;;;********** Enter Part Parameters Processing **********

        (oli::sd-attach-item-attribute (oli::sd-pathname-to-obj *ObjectPathName*) "PARTsolutions-attribute" :attachment :contents :on-copy :copy :on-xform :maintain :values '("mident" "{$CADENAS_DATA%5C23d-libs%5Cnissei%5Cinduction_gear_motor%5Cgtr_midi_series_01kw_to_22kw%5Cg3_series%5Cparts%5Cgear_head.prj}%2C158%20{VTYP=3D}%2C{NB=HL28L2}%2C{LINA=HL28L2}%2C{NN=Gear%20Head}%2C{DATE=17.03.2016%2004:21:33}%2C{GEOMDATE=18.02.2015%2000:55:00}%2C{VERSION=}%2C{LINEID=310}%2C{LINESUBID=-1}%2C{WBVAR=}%20%20{NB=HL28L2}%2C{LINA=HL28L2}%2C{KT=DUMMY}%2C{GH=HL28L2}") :set-modified nil :check-read-only nil)
        (oli::sd-attach-item-attribute (oli::sd-pathname-to-obj *ObjectPathName*)  "DEFAULTATTR" :attachment :contents :on-copy :copy :on-xform :maintain :set-modified nil :check-read-only nil  :values '("NN" "Gear Head" "NB" "HL28L2" "NBSYN" "$GH." "LINA" "HL28L2" "GH" "HL28L2" "SUPPLIER" "NISSEI" "ARTICLENO" "HL28L2" "BOMINFO" "HL28L2" "CREATOR" "CADENAS GmbH" ))


        ;;;;;********** Leave Part Parameters Processing **********

        ;;;;;********** Enter Part Color Processing **********

        (oli::set_part_base_color :parts *ObjectPathName* :color :rgb (oli::gpnt3d 0.75294119119644 0.75294119119644 0.75294119119644))

        ;;;;;********** Leave Part Color Processing **********

        ;;;;;********** Enter Part Geometry Processing **********

            ;"Source Sketch Name: Sketch 1"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine -62.5 24.919019989049 -62.5 -120)
            (CreateSketchLine -62.5 -120 62.5 -120)
            (CreateSketchLine 62.5 -120 62.5 24.919019989049)
            (CreateSketchArc3Points 62.5 24.919019989049 61.942982011258 27.212469541064 60.396035660946 28.99492203038)
            (CreateSketchLine 60.396035660946 28.99492203038 25.8005823122 53.575902041331)
            (CreateSketchArc3Points 25.8005823122 53.575902041331 24.424495629566 54.263376439389 22.904546651254 54.5)
            (CreateSketchLine 22.904546651254 54.5 -22.904546651254 54.5)
            (CreateSketchArc3Points -22.904546651254 54.5 -24.424495629566 54.263376439389 -25.8005823122 53.575902041331)
            (CreateSketchLine -25.8005823122 53.575902041331 -60.396035660946 28.99492203038)
            (CreateSketchArc3Points -60.396035660946 28.99492203038 -61.942982011258 27.212469541064 -62.5 24.919019989049)
            ;"Source Feature Name: Base extrude 1"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                37
                :BOTH_SIDES
            )
            ;"Source Sketch Name: Sketch 2"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 37 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchArc3Points -46.268102424496 -46.205140431514 -40.470513651582 -67.29782204959 -20.625283131623 -76.5)
            (CreateSketchLine -20.625283131623 -76.5 20.625283131623 -76.5)
            (CreateSketchArc3Points 20.625283131623 -76.5 40.470513651582 -67.29782204959 46.268102424496 -46.205140431514)
            (CreateSketchLine 46.268102424496 -46.205140431514 37.477966658816 6.2771024462492)
            (CreateSketchLine 37.477966658816 6.2771024462492 -37.477966658816 6.2771024462492)
            (CreateSketchLine -37.477966658816 6.2771024462492 -46.268102424496 -46.205140431514)
            ;"Source Feature Name: Base extrude 2"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                6
                :+W
            )
            ;"Sketch Name: Sketch 24"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine 37 0 37 38)
            (CreateSketchLine 37 38 50.766337273807 34.362776800442)
            (CreateSketchArc3Points 50.766337273807 34.362776800442 52.376868930066 33.292742126332 53 31.462306634629)
            (CreateSketchLine 53 31.462306634629 53 15)
            (CreateSketchLine 53 15 55 15)
            (CreateSketchLine 55 15 55 14)
            (CreateSketchLine 55 14 100 14)
            (CreateSketchLine 100 14 100 0)
            (CreateSketchLine 100 0 37 0)
            ;"Feature Name: Base rotate 1"
            (CreateRevolveBase
                *ObjectPathName* 
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 100 :y 0 :z 0)
                (oli::make-gpnt3d :x 37 :y 0 :z 0)
                180
                :BOTH_SIDES
            )
            ;"Source Sketch Name: Sketch 6"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 10 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
            )
            (CreateSketchArc3Points 64 4 60 4.8985871965894e-16 64 -4)
            (CreateSketchLine 64 -4 101 -4)
            (CreateSketchLine 101 -4 101 4)
            (CreateSketchLine 101 4 64 4)
            ;"Source Feature Name: Cut extrude 1"
            (CreateExtrudeCut
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                6
                :+W
            )
            ;"Source Sketch Name: Sketch 15"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z -74)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchCircle 0 -36 64)
            ;"Source Feature Name: Base extrude 5"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                15
                :+W
            )
            ;"Source Sketch Name: Sketch 25"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
            )
            (CreateSketchLine -65 90 -65 50)
            (CreateSketchLine -65 50 -37 50)
            (CreateSketchLine -37 50 -37 80)
            (CreateSketchLine -37 80 37 80)
            (CreateSketchLine 37 80 37 50)
            (CreateSketchLine 37 50 65 50)
            (CreateSketchLine 65 50 65 90)
            (CreateSketchLine 65 90 -65 90)
            ;"Source Feature Name: Cut extrude 6"
            (CreateExtrudeCut
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                95
                :BOTH_SIDES
            )
            ;"Sketch Name: Sketch 26"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y -36 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
            )
            (CreateSketchLine 0 69 -61 69)
            (CreateSketchArc3Points -61 69 -63.12132034356 69.87867965644 -64 72)
            (CreateSketchLine -64 72 -64 82.5)
            (CreateSketchLine -64 82.5 0 82.5)
            (CreateSketchLine 0 82.5 0 69)
            ;"Feature Name: Base rotate 3"
            (CreateRevolveBase
                *ObjectPathName* 
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y -36 :z -82.5)
                (oli::make-gpnt3d :x 0 :y -36 :z -69)
                180
                :BOTH_SIDES
            )
            ;"Source Sketch Name: Sketch 3"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x -37 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchArc3Points -46.268102424496 -46.205140431514 -40.470513651582 -67.29782204959 -20.625283131623 -76.5)
            (CreateSketchLine -20.625283131623 -76.5 20.625283131623 -76.5)
            (CreateSketchArc3Points 20.625283131623 -76.5 40.470513651582 -67.29782204959 46.268102424496 -46.205140431514)
            (CreateSketchLine 46.268102424496 -46.205140431514 37.477966658816 6.2771024462492)
            (CreateSketchLine 37.477966658816 6.2771024462492 -37.477966658816 6.2771024462492)
            (CreateSketchLine -37.477966658816 6.2771024462492 -46.268102424496 -46.205140431514)
            ;"Source Feature Name: Base extrude 3"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                6
                :-W
            )
            ;"Sketch Name: Sketch 9"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine -53 0 -53 31.462306634629)
            (CreateSketchArc3Points -53 31.462306634629 -52.376868930066 33.292742126332 -50.766337273807 34.362776800442)
            (CreateSketchLine -50.766337273807 34.362776800442 -37 38)
            (CreateSketchLine -37 38 -37 0)
            (CreateSketchLine -37 0 -53 0)
            ;"Feature Name: Base rotate 2"
            (CreateRevolveBase
                *ObjectPathName* 
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x -37 :y 0 :z 0)
                (oli::make-gpnt3d :x -53 :y 0 :z 0)
                180
                :BOTH_SIDES
            )
            ;"Source Sketch Name: Sketch 4"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x -37 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine 4.9 -59 4.9 -64)
            (CreateSketchLine 4.9 -64 14.685007082148 -64)
            (CreateSketchArc3Points 14.685007082148 -64 15.536288907888 -58.115021829716 11.243941746658 -54)
            (CreateSketchLine 11.243941746658 -54 4.9 -54)
            (CreateSketchLine 4.9 -54 4.9 -57.5)
            (CreateSketchLine 4.9 -57.5 10.606828471339 -57.5)
            (CreateSketchArc3Points 10.606828471339 -57.5 12.355091101129 -60.056904004403 11.38949994999 -63)
            (CreateSketchLine 11.38949994999 -63 8.15 -63)
            (CreateSketchLine 8.15 -63 8.15 -59)
            (CreateSketchLine 8.15 -59 4.9 -59)
            ;"Source Feature Name: Base extrude 4"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                8.4
                :-W
            )
            ;"Source Sketch Name: Sketch 7"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x -37 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine -3.5 -57.5 -1.75 -57.5)
            (CreateSketchLine -1.75 -57.5 -1.75 -64)
            (CreateSketchLine -1.75 -64 1.75 -64)
            (CreateSketchLine 1.75 -64 1.75 -57.5)
            (CreateSketchLine 1.75 -57.5 3.5 -57.5)
            (CreateSketchLine 3.5 -57.5 3.5 -54)
            (CreateSketchLine 3.5 -54 -3.5 -54)
            (CreateSketchLine -3.5 -54 -3.5 -57.5)
            ;"Source Feature Name: Base extrude 9"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                8.4
                :-W
            )
            ;"Source Sketch Name: Sketch 8"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x -37 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchArc3Points -13.139971264131 -54 -15.837850563776 -57.404693101072 -14.400203688312 -61.503919770752)
            (CreateSketchLine -14.400203688312 -61.503919770752 -15.9 -64)
            (CreateSketchLine -15.9 -64 -12.10844145905 -64)
            (CreateSketchLine -12.10844145905 -64 -9.1041383639124 -59)
            (CreateSketchLine -9.1041383639124 -59 -11.35 -59)
            (CreateSketchArc3Points -11.35 -59 -12.1 -58.25 -11.35 -57.5)
            (CreateSketchLine -11.35 -57.5 -7.85 -57.5)
            (CreateSketchLine -7.85 -57.5 -7.85 -64)
            (CreateSketchLine -7.85 -64 -4.6 -64)
            (CreateSketchLine -4.6 -64 -4.6 -54)
            (CreateSketchLine -4.6 -54 -13.139971264131 -54)
            ;"Source Feature Name: Base extrude 10"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                8.4
                :-W
            )
            ;"Source Sketch Name: Sketch 18"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 37 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchArc3Points -11.443941746658 -54 -15.736288907888 -58.115021829716 -14.885007082148 -64)
            (CreateSketchLine -14.885007082148 -64 -5.1 -64)
            (CreateSketchLine -5.1 -64 -5.1 -59)
            (CreateSketchLine -5.1 -59 -8.35 -59)
            (CreateSketchLine -8.35 -59 -8.35 -63)
            (CreateSketchLine -8.35 -63 -11.58949994999 -63)
            (CreateSketchArc3Points -11.58949994999 -63 -12.555091101129 -60.056904004403 -10.806828471339 -57.5)
            (CreateSketchLine -10.806828471339 -57.5 -5.1 -57.5)
            (CreateSketchLine -5.1 -57.5 -5.1 -54)
            (CreateSketchLine -5.1 -54 -11.443941746658 -54)
            ;"Source Feature Name: Base extrude 6"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                8.4
                :+W
            )
            ;"Source Sketch Name: Sketch 19"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 37 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine -3.5 -57.5 -1.75 -57.5)
            (CreateSketchLine -1.75 -57.5 -1.75 -64)
            (CreateSketchLine -1.75 -64 1.75 -64)
            (CreateSketchLine 1.75 -64 1.75 -57.5)
            (CreateSketchLine 1.75 -57.5 3.5 -57.5)
            (CreateSketchLine 3.5 -57.5 3.5 -54)
            (CreateSketchLine 3.5 -54 -3.5 -54)
            (CreateSketchLine -3.5 -54 -3.5 -57.5)
            ;"Source Feature Name: Base extrude 7"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                8.4
                :+W
            )
            ;"Source Sketch Name: Sketch 20"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 37 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine 5.4 -64 8.65 -64)
            (CreateSketchLine 8.65 -64 8.65 -57.5)
            (CreateSketchLine 8.65 -57.5 12.15 -57.5)
            (CreateSketchArc3Points 12.15 -57.5 12.9 -58.25 12.15 -59)
            (CreateSketchLine 12.15 -59 9.9041383639124 -59)
            (CreateSketchLine 9.9041383639124 -59 12.90844145905 -64)
            (CreateSketchLine 12.90844145905 -64 16.7 -64)
            (CreateSketchLine 16.7 -64 15.200203688312 -61.503919770752)
            (CreateSketchArc3Points 15.200203688312 -61.503919770752 16.637850563776 -57.404693101072 13.939971264131 -54)
            (CreateSketchLine 13.939971264131 -54 5.4 -54)
            (CreateSketchLine 5.4 -54 5.4 -64)
            ;"Source Feature Name: Base extrude 8"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                8.4
                :+W
            )
            ;"Source Sketch Name: Sketch 10"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y -120 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
            )
            (CreateSketchLine 37 -62.5 59.635552819416 -54.664616331741)
            (CreateSketchArc3Points 59.635552819416 -54.664616331741 62.072945132032 -52.839878708386 63 -49.939685964539)
            (CreateSketchLine 63 -49.939685964539 63 49.939685964539)
            (CreateSketchArc3Points 63 49.939685964539 62.072945132032 52.839878708386 59.635552819416 54.664616331741)
            (CreateSketchLine 59.635552819416 54.664616331741 37 62.5)
            (CreateSketchLine 37 62.5 37 -62.5)
            ;"Source Feature Name: Base extrude 11"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                15
                :+W
            )
            ;"Source Sketch Name: Sketch 12"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y -120 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
            )
            (CreateSketchLine -63 49.939685964539 -63 -49.939685964539)
            (CreateSketchArc3Points -63 -49.939685964539 -62.072945132032 -52.839878708386 -59.635552819416 -54.664616331741)
            (CreateSketchLine -59.635552819416 -54.664616331741 -37 -62.5)
            (CreateSketchLine -37 -62.5 -37 62.5)
            (CreateSketchLine -37 62.5 -59.635552819416 54.664616331741)
            (CreateSketchArc3Points -59.635552819416 54.664616331741 -62.072945132032 52.839878708386 -63 49.939685964539)
            ;"Source Feature Name: Base extrude 12"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                15
                :+W
            )
            ;"Source Sketch Name: Sketch 13"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine -25 -120 25 -120)
            (CreateSketchLine 25 -120 24 -119)
            (CreateSketchLine 24 -119 -24 -119)
            (CreateSketchLine -24 -119 -25 -120)
            ;"Source Feature Name: Cut extrude 2"
            (CreateExtrudeCut
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                65
                :BOTH_SIDES
            )
            ;"Source Sketch Name: Sketch 14"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine 37 -98 37 -105)
            (CreateSketchLine 37 -105 60 -105)
            (CreateSketchLine 60 -105 37 -98)
            ;"Source Feature Name: Base extrude 13"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                20
                :BOTH_SIDES
            )
            ;"Source Sketch Name: Sketch 16"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine -60 -105 -37 -105)
            (CreateSketchLine -37 -105 -37 -98)
            (CreateSketchLine -37 -98 -60 -105)
            ;"Source Feature Name: Base extrude 14"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                20
                :BOTH_SIDES
            )
            ;"Sketch Name: Sketch 17_ALT_Drilling 1"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z -40)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine 50 -104 55.5 -104)
            (CreateSketchLine 55.5 -104 55.5 -121)
            (CreateSketchLine 55.5 -121 50 -121)
            (CreateSketchLine 50 -121 50 -104)
            ;"Source Feature Name: Cut rotate 1_ALT_Drilling 1"
            (CreateRevolveCut
                *ObjectPathName* 
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 50 :y -121 :z -40)
                (oli::make-gpnt3d :x 50 :y -104 :z -40)
                360
                :-W
            )
            ;"Sketch Name: Sketch 21_ALT_Drilling 2"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z -40)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine -50 -104 -44.5 -104)
            (CreateSketchLine -44.5 -104 -44.5 -121)
            (CreateSketchLine -44.5 -121 -50 -121)
            (CreateSketchLine -50 -121 -50 -104)
            ;"Source Feature Name: Cut rotate 2_ALT_Drilling 2"
            (CreateRevolveCut
                *ObjectPathName* 
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x -50 :y -121 :z -40)
                (oli::make-gpnt3d :x -50 :y -104 :z -40)
                360
                :-W
            )
            ;"Sketch Name: Sketch 22_ALT_Drilling 3"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 40)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine 50 -104 55.5 -104)
            (CreateSketchLine 55.5 -104 55.5 -121)
            (CreateSketchLine 55.5 -121 50 -121)
            (CreateSketchLine 50 -121 50 -104)
            ;"Source Feature Name: Cut rotate 3_ALT_Drilling 3"
            (CreateRevolveCut
                *ObjectPathName* 
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 50 :y -121 :z 40)
                (oli::make-gpnt3d :x 50 :y -104 :z 40)
                360
                :-W
            )
            ;"Sketch Name: Sketch 23_ALT_Drilling 4"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 40)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine -50 -104 -44.5 -104)
            (CreateSketchLine -44.5 -104 -44.5 -121)
            (CreateSketchLine -44.5 -121 -50 -121)
            (CreateSketchLine -50 -121 -50 -104)
            ;"Source Feature Name: Cut rotate 4_ALT_Drilling 4"
            (CreateRevolveCut
                *ObjectPathName* 
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x -50 :y -121 :z 40)
                (oli::make-gpnt3d :x -50 :y -104 :z 40)
                360
                :-W
            )

        ;;;;;********** Leave Part Geometry Processing **********

        ;;;;;********** Enter Connection Points Processing **********


        ;;;;;********** Leave Connection Points Processing **********

        ;;;;;********** Enter Surface Color Processing **********


        ;;;;;********** Leave Surface Color Processing **********

        ;;;;;********** Enter Negative Feature Processing **********

        (oli::sd-attach-item-attribute (oli::sd-pathname-to-obj *ObjectPathName*) "PARTsolutions-Negative" :attachment :contents :on-copy :copy :on-xform :maintain :on-merge :detach :values '("IsNegative" "0") :set-modified nil :check-read-only nil)

        ;;;;;********** Leave Negative Feature Processing **********

        ;;;;;********** Enter Physical Properties Processing **********


        (if (not (oli::sd-inq-empty-part-p (oli::sd-pathname-to-obj *ObjectPathName*)))
            (progn
                (oli::assign_mp_data :parcel (oli::sd-pathname-to-obj *ObjectPathName*)
                    :wetted_area (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :area))
                    :solid_volume (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :volume))
                    :centroid (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :centroid))
                    :prin_1 (first (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :principal)))
                    :prin_2 (second (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :principal)))
                    :prin_3 (third (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :principal)))
                    :mmi_1 (oli::gpnt3d_x (first (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :inertia_ref_coord))))
                    :mmi_2 (oli::gpnt3d_y (second (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :inertia_ref_coord))))
                    :mmi_3 (oli::gpnt3d_z (third (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :inertia_ref_coord))))
                )
            )
        )

        ;;;;;********** Leave Physical Properties Processing **********

        ;;;;;********** Enter Document Properties Processing **********

        (aftercreate_1)

        (setq name-in-library (oli::sd-set-library-attr (oli::sd-pathname-to-obj *ObjectPathName*) "PSOL" "HL28L2"))

        ;;;;;********** Leave Document Properties Processing **********

    )

    ;;;;;**********End PartCreate**********


    (Log 1 "Leave GenerateObject_1")
)

(defun CreateNewPart_1()
    (Log 1 "Enter CreateNewPart_1")
    (GenerateObject_1)
    (Log 1 "Leave CreateNewPart_1")
    (return-from CreateNewPart_1 t)
)

(defun BuildPart_1()
    (Log 2 "Enter BuildPart_1")
    (Log 2 "Part Name:     HL28L2")
    (Log 2 "Pool Path:     \\10.0.0.236\data_v9/pool/onespacemodeller/")
    (Log 2 "File Name:     HL28L2")
    (Log 2 "Display Name:  HL28L2")
    (Log 2 "ObjectPath:    /HL28L2")

    (OnOpen_1)

	 (if (= *OnOpenValue* 1)
        (progn
            (Log 2 "Loaded Part From Session After OnOpen")
            (Log 2 "Leave BuildPart_1")
	         (return-from BuildPart_1 t)
        )
	 )

	 (if (not (CreateNewPart_1))
		 (progn
			 (Log 4 "Part Creation Failed. Aborting With Fatal Error")
            (Log 2 "Leave BuildPart_1")
			 (return-from BuildPart_1 nil)
		 )
        (progn
            (Log 2 "Part Creation Succeeded")
        )
	 )

	 (beforesave_1)
	 (onsave_1)
	 (aftersave_1)

    (Log 2 "Leave BuildPart_1")
	 (return-from BuildPart_1 t)
)

    ;;;;;********** Enter Part Creation Main "HL28L2" **********
    (BuildPart_1)
    ;;;;;********** Leave Part Creation Main "HL28L2" **********

    (transform-document (oli::sd-inq-curr-part) 0 0 0 1 0 0 0 1 0 0 0 0 0 0 1 0 1 0)
        (let
            (
                (volLocal 0)
                (surfaceLocal 0)
                (massLocal 0)
            )
            (if (HasGeometry (oli::sd-pathname-to-obj *ObjectPathName*))
                (progn
                    (setf volLocal (oli::sd-call-cmds (oli::get_vol_prop :for_part (oli::sd-pathname-to-obj *ObjectPathName*) :volume)))
                    (setf surfaceLocal (oli::sd-call-cmds (oli::get_vol_prop :for_part (oli::sd-pathname-to-obj *ObjectPathName*) :area)))
                    (setf massLocal (oli::sd-call-cmds (oli::get_vol_prop :for_part (oli::sd-pathname-to-obj *ObjectPathName*) :mass)))
                )
            )

            (setf volTotal (+ volTotal volLocal))
            (setf surfaceTotal (+ surfaceTotal surfaceLocal))
            (setf massTotal (+ massTotal massLocal))
        )

        (defparameter *ObjectParentName* SAVEPARENT)
        (defparameter *ObjectAsmName* SAVEASM)
        (defparameter *ObjectPathName* SAVEPATH)
    )


    (let ((SAVEPARENT *ObjectParentName*) (SAVEASM *ObjectAsmName*) (SAVEPATH *ObjectPathName*))
(defun onopen_2()
    (Log 2 (concatenate 'string "Calling Callback " "DocOnOpen"))
        (Log 2 "Enter Callback SessionPartOnOpen")
    (Log 2 "Content Name:      GH010")

    (defparameter *OnOpenValue* 0)
    (defparameter *OnOpenName* nil)

    (let
        (
            (fileName "GH010")
            (displayName (oli::sd-gen-obj-basename :part :parent *ObjectParentName* :prefix "GH010."))
        )
        (PartExists "GH010")

        (if (not (= *PartExistsValue* 0))
            (progn
                (Log 2 (concatenate 'string "Found Content At:  " *PartExistsName*))

                (oli::create_MULTIPLE_PA :share :owner *ObjectParentName* :name displayName :source *PartExistsName*)

                (let (tVec xVec zVec tx ty tz xx xy xz zx zy zz)
                   (setf tVec (oli::sd-vec-xform 0,0,0 :source-space (oli::sd-inq-curr-part) :dest-space :global))
                   (setf xVec (oli::sd-vec-xform 1,0,0 :source-space (oli::sd-inq-curr-part) :dest-space :global))
                   (setf zVec (oli::sd-vec-xform 0,0,1 :source-space (oli::sd-inq-curr-part) :dest-space :global))

                   (setf tx   (oli::gpnt3d_x tVec))
                   (setf ty   (oli::gpnt3d_y tVec))
                   (setf tz   (oli::gpnt3d_z tVec))

                   (setf xx   (oli::gpnt3d_x xVec))
                   (setf xy   (oli::gpnt3d_y xVec))
                   (setf xz   (oli::gpnt3d_z xVec))

                   (setf zx   (oli::gpnt3d_x zVec))
                   (setf zy   (oli::gpnt3d_y zVec))
                   (setf zz   (oli::gpnt3d_z zVec))

                   (transform-document (oli::sd-inq-curr-part) tx ty tz xx xy xz zx zy zz 0 0 0 1 0 0 0 0 1)
                )

                (defparameter *OnOpenValue* 1)
                (defparameter *OnOpenName* (concatenate 'string *ObjectParentName* "/" displayName))
                (defparameter *ObjectPathName* *OnOpenName*)
                (Log 2 (concatenate 'string "New Instance Path: " *ObjectPathName*))
            )
            (progn
                (Log 2 "Content Not Found In Session")
            )
        )
    )

    (Log 2 "Leave Callback SessionPartOnOpen")
    (Log 2 (concatenate 'string "Called Callback " "DocOnOpen"))
)

(defun beforecreate_2()
    (Log 2 (concatenate 'string "Calling Callback " "DocBeforeCreate"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocBeforeCreate"))
)

(defun aftercreate_2()
    (Log 2 (concatenate 'string "Calling Callback " "DocAfterCreate"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocAfterCreate"))
)

(defun beforesave_2()
    (Log 2 (concatenate 'string "Calling Callback " "DocBeforeSave"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocBeforeSave"))
)

(defun onsave_2()
    (Log 2 (concatenate 'string "Calling Callback " "DocOnSave"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocOnSave"))
)

(defun aftersave_2()
    (Log 2 (concatenate 'string "Calling Callback " "DocAfterSave"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocAfterSave"))
)

(defun GenerateObject_2()
    (Log 1 "Enter GenerateObject_2")

    ;;;;;********** Enter CreatePart **********

    (defparameter *ObjectPartName* "GH010" "GH010")

    (if (string= *ObjectParentName* "/")
        (defparameter *ObjectPathName* (concatenate 'string *ObjectParentName* *ObjectPartName*))
        (defparameter *ObjectPathName* (concatenate 'string *ObjectParentName* "/" *ObjectPartName*))
    )

    (progn
        (oli::create_part :owner *ObjectParentName* :name *ObjectPartName*)
        (defparameter *ObjectPartName* "GH010")
        (defparameter *ObjectPartModelName* "GH010")
        (oli::change_name_pa :part_asmb *ObjectPathName* :name *ObjectPartModelName* :model_name *ObjectPartName*)
        (defparameter *ObjectPathName* (concatenate 'string *ObjectParentName* "/" *ObjectPartModelName*))

        (beforecreate_2)

        ;;;;;********** Enter Part Parameters Processing **********

        (oli::sd-attach-item-attribute (oli::sd-pathname-to-obj *ObjectPathName*) "PARTsolutions-attribute" :attachment :contents :on-copy :copy :on-xform :maintain :values '("mident" "{$CADENAS_DATA%5C23d-libs%5Cnissei%5Cinduction_gear_motor%5Cgtr_midi_series_01kw_to_22kw%5Cg3_series%5Cparts%5Cmiddle_reducer_or_clutch.prj}%2C171%20{VTYP=3D}%2C{NB=GH010}%2C{LINA=GH010}%2C{NN=Middle%20reducer%20or%20Clutch}%2C{DATE=27.05.2016%2006:19:13}%2C{GEOMDATE=27.05.2016%2005:58:00}%2C{VERSION=}%2C{LINEID=170}%2C{LINESUBID=-1}%2C{WBVAR=}%20%20{NB=GH010}%2C{LINA=GH010}%2C{KT=DUMMY}%2C{MRC=GH010}") :set-modified nil :check-read-only nil)
        (oli::sd-attach-item-attribute (oli::sd-pathname-to-obj *ObjectPathName*)  "DEFAULTATTR" :attachment :contents :on-copy :copy :on-xform :maintain :set-modified nil :check-read-only nil  :values '("NN" "Middle reducer or Clutch" "NB" "GH010" "NBSYN" "$MRC." "LINA" "GH010" "MRC" "GH010" "SUPPLIER" "NISSEI" "ARTICLENO" "GH010" "BOMINFO" "GH010" "CREATOR" "CADENAS GmbH" ))


        ;;;;;********** Leave Part Parameters Processing **********

        ;;;;;********** Enter Part Color Processing **********

        (oli::set_part_base_color :parts *ObjectPathName* :color :rgb (oli::gpnt3d 0.75294119119644 0.75294119119644 0.75294119119644))

        ;;;;;********** Leave Part Color Processing **********

        ;;;;;********** Enter Part Geometry Processing **********

            ;"Sketch Name: Sketch 1"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine 0 0 0 57.5)
            (CreateSketchLine 0 57.5 8.5 57.5)
            (CreateSketchLine 8.5 57.5 32.038389348589 61.652596602364)
            (CreateSketchArc3Points 32.038389348589 61.652596602364 35.953741383314 63.913471954249 37.5 68.162074454239)
            (CreateSketchLine 37.5 68.162074454239 37.5 100)
            (CreateSketchLine 37.5 100 50 100)
            (CreateSketchLine 50 100 50 0)
            (CreateSketchLine 50 0 0 0)
            ;"Feature Name: Base rotate 1"
            (CreateRevolveBase
                *ObjectPathName* 
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 50 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                180
                :BOTH_SIDES
            )
            ;"Sketch Name: Sketch 2"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine 50 -27.5 50 36.5)
            (CreateSketchLine 50 36.5 13.325502516487 37.780701672847)
            (CreateSketchArc3Points 13.325502516487 37.780701672847 9.9033009983067 39.304363955648 8.5 42.777655807943)
            (CreateSketchLine 8.5 42.777655807943 8.5 106.5)
            (CreateSketchLine 8.5 106.5 70 106.5)
            (CreateSketchLine 70 106.5 70 -27.5)
            (CreateSketchLine 70 -27.5 50 -27.5)
            ;"Source Feature Name: Cut rotate 1"
            (CreateRevolveCut
                *ObjectPathName* 
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 70 :y -27.5 :z 0)
                (oli::make-gpnt3d :x 50 :y -27.5 :z 0)
                360
                :-W
            )
            ;"Source Sketch Name: Sketch 3"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 18.75 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchCircle 41.01 13.51 8.5)
            ;"Source Feature Name: Base extrude 1"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                21
                :+W
            )
            ;"Source Sketch Name: Sketch 4"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 18.75 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchCircle -41.01 13.51 8.5)
            ;"Source Feature Name: Base extrude 2"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                21
                :+W
            )
            ;"Sketch Name: Sketch 7_ALT_Drilling 1"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine 3.5 51 3.5 53.5)
            (CreateSketchLine 3.5 53.5 8.5 53.5)
            (CreateSketchLine 8.5 53.5 8.5 51)
            (CreateSketchLine 8.5 51 3.5 51)
            ;"Source Feature Name: Cut rotate 2_ALT_Drilling 1"
            (CreateRevolveCut
                *ObjectPathName* 
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 8.5 :y 51 :z 0)
                (oli::make-gpnt3d :x 3.5 :y 51 :z 0)
                360
                :-W
            )

        ;;;;;********** Leave Part Geometry Processing **********

        ;;;;;********** Enter Connection Points Processing **********


        ;;;;;********** Leave Connection Points Processing **********

        ;;;;;********** Enter Surface Color Processing **********


        ;;;;;********** Leave Surface Color Processing **********

        ;;;;;********** Enter Negative Feature Processing **********

        (oli::sd-attach-item-attribute (oli::sd-pathname-to-obj *ObjectPathName*) "PARTsolutions-Negative" :attachment :contents :on-copy :copy :on-xform :maintain :on-merge :detach :values '("IsNegative" "0") :set-modified nil :check-read-only nil)

        ;;;;;********** Leave Negative Feature Processing **********

        ;;;;;********** Enter Physical Properties Processing **********


        (if (not (oli::sd-inq-empty-part-p (oli::sd-pathname-to-obj *ObjectPathName*)))
            (progn
                (oli::assign_mp_data :parcel (oli::sd-pathname-to-obj *ObjectPathName*)
                    :wetted_area (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :area))
                    :solid_volume (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :volume))
                    :centroid (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :centroid))
                    :prin_1 (first (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :principal)))
                    :prin_2 (second (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :principal)))
                    :prin_3 (third (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :principal)))
                    :mmi_1 (oli::gpnt3d_x (first (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :inertia_ref_coord))))
                    :mmi_2 (oli::gpnt3d_y (second (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :inertia_ref_coord))))
                    :mmi_3 (oli::gpnt3d_z (third (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :inertia_ref_coord))))
                )
            )
        )

        ;;;;;********** Leave Physical Properties Processing **********

        ;;;;;********** Enter Document Properties Processing **********

        (aftercreate_2)

        (setq name-in-library (oli::sd-set-library-attr (oli::sd-pathname-to-obj *ObjectPathName*) "PSOL" "GH010"))

        ;;;;;********** Leave Document Properties Processing **********

    )

    ;;;;;**********End PartCreate**********


    (Log 1 "Leave GenerateObject_2")
)

(defun CreateNewPart_2()
    (Log 1 "Enter CreateNewPart_2")
    (GenerateObject_2)
    (Log 1 "Leave CreateNewPart_2")
    (return-from CreateNewPart_2 t)
)

(defun BuildPart_2()
    (Log 2 "Enter BuildPart_2")
    (Log 2 "Part Name:     GH010")
    (Log 2 "Pool Path:     \\10.0.0.236\data_v9/pool/onespacemodeller/")
    (Log 2 "File Name:     GH010")
    (Log 2 "Display Name:  GH010")
    (Log 2 "ObjectPath:    /GH010")

    (OnOpen_2)

	 (if (= *OnOpenValue* 1)
        (progn
            (Log 2 "Loaded Part From Session After OnOpen")
            (Log 2 "Leave BuildPart_2")
	         (return-from BuildPart_2 t)
        )
	 )

	 (if (not (CreateNewPart_2))
		 (progn
			 (Log 4 "Part Creation Failed. Aborting With Fatal Error")
            (Log 2 "Leave BuildPart_2")
			 (return-from BuildPart_2 nil)
		 )
        (progn
            (Log 2 "Part Creation Succeeded")
        )
	 )

	 (beforesave_2)
	 (onsave_2)
	 (aftersave_2)

    (Log 2 "Leave BuildPart_2")
	 (return-from BuildPart_2 t)
)

    ;;;;;********** Enter Part Creation Main "GH010" **********
    (BuildPart_2)
    ;;;;;********** Leave Part Creation Main "GH010" **********

    (transform-document (oli::sd-inq-curr-part) 0 0 0 1 0 0 0 1 0 132.5 -8.5 0 131.5 -8.5 0 132.5 -7.5 0)
        (let
            (
                (volLocal 0)
                (surfaceLocal 0)
                (massLocal 0)
            )
            (if (HasGeometry (oli::sd-pathname-to-obj *ObjectPathName*))
                (progn
                    (setf volLocal (oli::sd-call-cmds (oli::get_vol_prop :for_part (oli::sd-pathname-to-obj *ObjectPathName*) :volume)))
                    (setf surfaceLocal (oli::sd-call-cmds (oli::get_vol_prop :for_part (oli::sd-pathname-to-obj *ObjectPathName*) :area)))
                    (setf massLocal (oli::sd-call-cmds (oli::get_vol_prop :for_part (oli::sd-pathname-to-obj *ObjectPathName*) :mass)))
                )
            )

            (setf volTotal (+ volTotal volLocal))
            (setf surfaceTotal (+ surfaceTotal surfaceLocal))
            (setf massTotal (+ massTotal massLocal))
        )

        (defparameter *ObjectParentName* SAVEPARENT)
        (defparameter *ObjectAsmName* SAVEASM)
        (defparameter *ObjectPathName* SAVEPATH)
    )


    (let ((SAVEPARENT *ObjectParentName*) (SAVEASM *ObjectAsmName*) (SAVEPATH *ObjectPathName*))
(defun onopen_3()
    (Log 2 (concatenate 'string "Calling Callback " "DocOnOpen"))
        (Log 2 "Enter Callback SessionPartOnOpen")
    (Log 2 "Content Name:      T010")

    (defparameter *OnOpenValue* 0)
    (defparameter *OnOpenName* nil)

    (let
        (
            (fileName "T010")
            (displayName (oli::sd-gen-obj-basename :part :parent *ObjectParentName* :prefix "T010."))
        )
        (PartExists "T010")

        (if (not (= *PartExistsValue* 0))
            (progn
                (Log 2 (concatenate 'string "Found Content At:  " *PartExistsName*))

                (oli::create_MULTIPLE_PA :share :owner *ObjectParentName* :name displayName :source *PartExistsName*)

                (let (tVec xVec zVec tx ty tz xx xy xz zx zy zz)
                   (setf tVec (oli::sd-vec-xform 0,0,0 :source-space (oli::sd-inq-curr-part) :dest-space :global))
                   (setf xVec (oli::sd-vec-xform 1,0,0 :source-space (oli::sd-inq-curr-part) :dest-space :global))
                   (setf zVec (oli::sd-vec-xform 0,0,1 :source-space (oli::sd-inq-curr-part) :dest-space :global))

                   (setf tx   (oli::gpnt3d_x tVec))
                   (setf ty   (oli::gpnt3d_y tVec))
                   (setf tz   (oli::gpnt3d_z tVec))

                   (setf xx   (oli::gpnt3d_x xVec))
                   (setf xy   (oli::gpnt3d_y xVec))
                   (setf xz   (oli::gpnt3d_z xVec))

                   (setf zx   (oli::gpnt3d_x zVec))
                   (setf zy   (oli::gpnt3d_y zVec))
                   (setf zz   (oli::gpnt3d_z zVec))

                   (transform-document (oli::sd-inq-curr-part) tx ty tz xx xy xz zx zy zz 0 0 0 1 0 0 0 0 1)
                )

                (defparameter *OnOpenValue* 1)
                (defparameter *OnOpenName* (concatenate 'string *ObjectParentName* "/" displayName))
                (defparameter *ObjectPathName* *OnOpenName*)
                (Log 2 (concatenate 'string "New Instance Path: " *ObjectPathName*))
            )
            (progn
                (Log 2 "Content Not Found In Session")
            )
        )
    )

    (Log 2 "Leave Callback SessionPartOnOpen")
    (Log 2 (concatenate 'string "Called Callback " "DocOnOpen"))
)

(defun beforecreate_3()
    (Log 2 (concatenate 'string "Calling Callback " "DocBeforeCreate"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocBeforeCreate"))
)

(defun aftercreate_3()
    (Log 2 (concatenate 'string "Calling Callback " "DocAfterCreate"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocAfterCreate"))
)

(defun beforesave_3()
    (Log 2 (concatenate 'string "Calling Callback " "DocBeforeSave"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocBeforeSave"))
)

(defun onsave_3()
    (Log 2 (concatenate 'string "Calling Callback " "DocOnSave"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocOnSave"))
)

(defun aftersave_3()
    (Log 2 (concatenate 'string "Calling Callback " "DocAfterSave"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocAfterSave"))
)

(defun GenerateObject_3()
    (Log 1 "Enter GenerateObject_3")

    ;;;;;********** Enter CreatePart **********

    (defparameter *ObjectPartName* "T010" "T010")

    (if (string= *ObjectParentName* "/")
        (defparameter *ObjectPathName* (concatenate 'string *ObjectParentName* *ObjectPartName*))
        (defparameter *ObjectPathName* (concatenate 'string *ObjectParentName* "/" *ObjectPartName*))
    )

    (progn
        (oli::create_part :owner *ObjectParentName* :name *ObjectPartName*)
        (defparameter *ObjectPartName* "T010")
        (defparameter *ObjectPartModelName* "T010")
        (oli::change_name_pa :part_asmb *ObjectPathName* :name *ObjectPartModelName* :model_name *ObjectPartName*)
        (defparameter *ObjectPathName* (concatenate 'string *ObjectParentName* "/" *ObjectPartModelName*))

        (beforecreate_3)

        ;;;;;********** Enter Part Parameters Processing **********

        (oli::sd-attach-item-attribute (oli::sd-pathname-to-obj *ObjectPathName*) "PARTsolutions-attribute" :attachment :contents :on-copy :copy :on-xform :maintain :values '("mident" "{$CADENAS_DATA%5C23d-libs%5Cnissei%5Cinduction_gear_motor%5Cgtr_midi_series_01kw_to_22kw%5Cg3_series%5Cparts%5Cmotor.prj}%2C149%20{VTYP=3D}%2C{NB=T010}%2C{LINA=T010}%2C{NN=Motor}%2C{DATE=17.03.2016%2004:21:33}%2C{GEOMDATE=11.02.2014%2008:43:00}%2C{VERSION=}%2C{LINEID=10}%2C{LINESUBID=-1}%2C{WBVAR=}%20%20{NB=T010}%2C{LINA=T010}%2C{KT=DUMMY}%2C{M=T010}") :set-modified nil :check-read-only nil)
        (oli::sd-attach-item-attribute (oli::sd-pathname-to-obj *ObjectPathName*)  "DEFAULTATTR" :attachment :contents :on-copy :copy :on-xform :maintain :set-modified nil :check-read-only nil  :values '("NN" "Motor" "NB" "T010" "NBSYN" "$M." "LINA" "T010" "M" "T010" "SUPPLIER" "NISSEI" "ARTICLENO" "T010" "BOMINFO" "T010" "CREATOR" "CADENAS GmbH" ))


        ;;;;;********** Leave Part Parameters Processing **********

        ;;;;;********** Enter Part Color Processing **********

        (oli::set_part_base_color :parts *ObjectPathName* :color :rgb (oli::gpnt3d 0.75294119119644 0.75294119119644 0.75294119119644))

        ;;;;;********** Leave Part Color Processing **********

        ;;;;;********** Enter Part Geometry Processing **********

            ;"Source Sketch Name: Sketch 1"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchCircle 0 0 57.5)
            ;"Source Feature Name: Base extrude 1"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                44.5
                :BOTH_SIDES
            )
            ;"Source Sketch Name: Sketch 9"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine -65.325 65.325 -65.325 -65.325)
            (CreateSketchLine -65.325 -65.325 65.325 -65.325)
            (CreateSketchLine 65.325 -65.325 65.325 65.325)
            (CreateSketchLine 65.325 65.325 -65.325 65.325)
            (CreateSketchArc3Points -56.817546889498 1.0035080977395 -57.78705984994 -0.030621076003841 -56.758066826138 -1.0055835806257)
            (CreateSketchLine -56.758066826138 -1.0055835806257 -55.235432944127 -1.0587139975337)
            (CreateSketchArc3Points -55.235432944127 -1.0587139975337 -54.896458078918 -1.2067682721722 -54.750656788724 -1.5467182850571)
            (CreateSketchArc3Points -54.750656788724 -1.5467182850571 -54.63411327277 -3.8910696663193 -54.417234012979 -6.2282741290526)
            (CreateSketchArc3Points -54.417234012979 -6.2282741290526 -54.535719370142 -6.6133355073348 -54.898953266078 -6.7876096527691)
            (CreateSketchLine -54.898953266078 -6.7876096527691 -56.234372411024 -6.8377081641829)
            (CreateSketchArc3Points -56.234372411024 -6.8377081641829 -57.142957712476 -7.8686262621531 -56.17348423542 -8.8425053881352)
            (CreateSketchLine -56.17348423542 -8.8425053881352 -54.450887511619 -8.9061499503591)
            (CreateSketchArc3Points -54.450887511619 -8.9061499503591 -54.138090174788 -9.0296766266724 -53.973251711411 -9.3228137354902)
            (CreateSketchArc3Points -53.973251711411 -9.3228137354902 -53.514017270399 -11.673761683085 -52.952431867685 -14.002382495425)
            (CreateSketchArc3Points -52.952431867685 -14.002382495425 -53.034786617895 -14.430405171446 -53.420695196254 -14.633038547815)
            (CreateSketchLine -53.420695196254 -14.633038547815 -54.671572228487 -14.676724629175)
            (CreateSketchArc3Points -54.671572228487 -14.676724629175 -55.579988706098 -15.707727487375 -54.61048339773 -16.681507158275)
            (CreateSketchLine -54.61048339773 -16.681507158275 -52.494430332262 -16.755305263219)
            (CreateSketchArc3Points -52.494430332262 -16.755305263219 -52.210216434149 -16.855671137477 -52.034563236831 -17.100613585549)
            (CreateSketchArc3Points -52.034563236831 -17.100613585549 -51.326608518022 -19.120826715593 -50.540253771611 -21.111833292047)
            (CreateSketchArc3Points -50.540253771611 -21.111833292047 -50.621546230078 -22.041628365033 -51.432542133949 -22.503594798289)
            (CreateSketchLine -51.432542133949 -22.503594798289 -51.657912409771 -22.511460801572)
            (CreateSketchArc3Points -51.657912409771 -22.511460801572 -52.688617734037 -23.48555209942 -51.719047635238 -24.520511589222)
            (CreateSketchLine -51.719047635238 -24.520511589222 -49.520003933151 -24.597064785609)
            (CreateSketchArc3Points -49.520003933151 -24.597064785609 -49.017413612077 -24.752304226047 -48.66208653106 -25.140168867644)
            (CreateSketchArc3Points -48.66208653106 -25.140168867644 -47.569306057551 -27.151203977965 -46.393463476354 -29.114829604829)
            (CreateSketchArc3Points -46.393463476354 -29.114829604829 -46.352821426436 -30.11223398128 -47.192105539066 -30.652668478741)
            (CreateSketchArc3Points -47.192105539066 -30.652668478741 -48.144452393642 -31.665076402566 -47.174549398751 -32.660678583387)
            (CreateSketchLine -47.174549398751 -32.660678583387 -44.362859694831 -32.758821799543)
            (CreateSketchArc3Points -44.362859694831 -32.758821799543 -43.935828032074 -32.870742981207 -43.59795580136 -33.154863989959)
            (CreateSketchArc3Points -43.59795580136 -33.154863989959 -42.224675072533 -34.887011498106 -40.782621729373 -36.562337468068)
            (CreateSketchArc3Points -40.782621729373 -36.562337468068 -40.573385575445 -37.538394455487 -41.308837084974 -38.213359704913)
            (CreateSketchArc3Points -41.308837084974 -38.213359704913 -42.087314385756 -39.28780449071 -41.121818454061 -40.197901250094)
            (CreateSketchLine -41.121818454061 -40.197901250094 -37.419309481833 -40.327184659009)
            (CreateSketchArc3Points -37.419309481833 -40.327184659009 -37.076417480806 -40.400353467214 -36.779526839293 -40.586859471111)
            (CreateSketchArc3Points -36.779526839293 -40.586859471111 -35.006949044224 -42.125292578985 -33.170089694982 -43.586372937844)
            (CreateSketchArc3Points -33.170089694982 -43.586372937844 -32.780840638253 -44.505585743802 -33.376071248555 -45.306939305822)
            (CreateSketchArc3Points -33.376071248555 -45.306939305822 -33.96059395501 -46.416241789183 -33.008479486307 -47.232144254211)
            (CreateSketchLine -33.008479486307 -47.232144254211 -27.646697423588 -47.419265232814)
            (CreateSketchArc3Points -27.646697423588 -47.419265232814 -27.406812591595 -47.456992181193 -27.18297941443 -47.55115546866)
            (CreateSketchArc3Points -27.18297941443 -47.55115546866 -26.914924398964 -47.703391921833 -26.646016892446 -47.854117273412)
            (CreateSketchArc3Points -26.646016892446 -47.854117273412 -26.268508834734 -48.222928621746 -26.129934633591 -48.73217447109)
            (CreateSketchLine -26.129934633591 -48.73217447109 -26.129934633591 -50.921409700712)
            (CreateSketchArc3Points -26.129934633591 -50.921409700712 -25.97843845728 -51.452028417823 -25.569623742151 -51.82267358922)
            (CreateSketchArc3Points -25.569623742151 -51.82267358922 -6.9677207589066e-15 -57.7875 25.569623742151 -51.82267358922)
            (CreateSketchArc3Points 25.569623742151 -51.82267358922 25.97843845728 -51.452028417823 26.129934633591 -50.921409700712)
            (CreateSketchLine 26.129934633591 -50.921409700712 26.129934633591 -48.73217447109)
            (CreateSketchArc3Points 26.129934633591 -48.73217447109 26.268508834734 -48.222928621746 26.646016892446 -47.854117273412)
            (CreateSketchArc3Points 26.646016892446 -47.854117273412 26.914924398965 -47.703391921833 27.182979343574 -47.551155509166)
            (CreateSketchArc3Points 27.182979343574 -47.551155509166 27.406812591595 -47.456992181193 27.646697423588 -47.419265232814)
            (CreateSketchLine 27.646697423588 -47.419265232814 33.008479486307 -47.232144254211)
            (CreateSketchArc3Points 33.008479486307 -47.232144254211 33.96059395501 -46.416241789183 33.376071248555 -45.306939305822)
            (CreateSketchArc3Points 33.376071248555 -45.306939305822 32.780840638253 -44.505585743802 33.170089630034 -43.586372987271)
            (CreateSketchArc3Points 33.170089630034 -43.586372987271 35.006949044224 -42.125292578985 36.779526778814 -40.586859525916)
            (CreateSketchArc3Points 36.779526778814 -40.586859525916 37.076417480806 -40.400353467214 37.419309481833 -40.327184659009)
            (CreateSketchLine 37.419309481833 -40.327184659009 41.121818454061 -40.197901250094)
            (CreateSketchArc3Points 41.121818454061 -40.197901250094 42.087314385756 -39.28780449071 41.308837084974 -38.213359704913)
            (CreateSketchArc3Points 41.308837084974 -38.213359704913 40.573385575445 -37.538394455487 40.782621729373 -36.562337468068)
            (CreateSketchArc3Points 40.782621729373 -36.562337468068 42.224675072533 -34.887011498106 43.59795580136 -33.154863989959)
            (CreateSketchArc3Points 43.59795580136 -33.154863989959 43.935828032074 -32.870742981207 44.362859694831 -32.758821799543)
            (CreateSketchLine 44.362859694831 -32.758821799543 47.174549398751 -32.660678583387)
            (CreateSketchArc3Points 47.174549398751 -32.660678583387 48.144452393642 -31.665076402566 47.192104960567 -30.652668448414)
            (CreateSketchArc3Points 47.192104960567 -30.652668448414 46.352821426436 -30.11223398128 46.393463519738 -29.114829535697)
            (CreateSketchArc3Points 46.393463519738 -29.114829535697 47.56930605755 -27.151203977966 48.66208653106 -25.140168867644)
            (CreateSketchArc3Points 48.66208653106 -25.140168867644 49.017413612077 -24.752304226047 49.520003933151 -24.597064785609)
            (CreateSketchLine 49.520003933151 -24.597064785609 51.719047635238 -24.520511589222)
            (CreateSketchArc3Points 51.719047635238 -24.520511589222 52.688617734037 -23.48555209942 51.657912409771 -22.511460801572)
            (CreateSketchLine 51.657912409771 -22.511460801572 51.432542133949 -22.503594798289)
            (CreateSketchArc3Points 51.432542133949 -22.503594798289 50.621546230078 -22.041628365033 50.540253771611 -21.111833292047)
            (CreateSketchArc3Points 50.540253771611 -21.111833292047 51.326608518022 -19.120826715593 52.034563236831 -17.100613585549)
            (CreateSketchArc3Points 52.034563236831 -17.100613585549 52.210216434149 -16.855671137477 52.494430332262 -16.755305263219)
            (CreateSketchLine 52.494430332262 -16.755305263219 54.61048339773 -16.681507158275)
            (CreateSketchArc3Points 54.61048339773 -16.681507158275 55.579988706098 -15.707727487375 54.671572228486 -14.676724629175)
            (CreateSketchLine 54.671572228486 -14.676724629175 53.420695196254 -14.633038547815)
            (CreateSketchArc3Points 53.420695196254 -14.633038547815 53.034786617895 -14.430405171446 52.952431851749 -14.002382555689)
            (CreateSketchArc3Points 52.952431851749 -14.002382555689 53.514017270399 -11.673761683085 53.973251567854 -9.3228145665987)
            (CreateSketchArc3Points 53.973251567854 -9.3228145665987 54.138090174787 -9.0296766266725 54.450887511619 -8.9061499503591)
            (CreateSketchLine 54.450887511619 -8.9061499503591 56.27398423542 -8.8425053881352)
            (CreateSketchArc3Points 56.27398423542 -8.8425053881352 57.243457712476 -7.8686262621531 56.334872411023 -6.8377081641829)
            (CreateSketchLine 56.334872411023 -6.8377081641829 54.898953266078 -6.7876096527691)
            (CreateSketchArc3Points 54.898953266078 -6.7876096527691 54.535719370143 -6.6133355073348 54.417233891998 -6.2282751860846)
            (CreateSketchArc3Points 54.417233891998 -6.2282751860846 54.63411327277 -3.8910696663194 54.750656788724 -1.5467182850572)
            (CreateSketchArc3Points 54.750656788724 -1.5467182850572 54.896458078918 -1.2067682721722 55.235432944127 -1.0587139975337)
            (CreateSketchLine 55.235432944127 -1.0587139975337 56.758066826137 -1.0055835806257)
            (CreateSketchArc3Points 56.758066826137 -1.0055835806257 57.78705984994 -0.030621076003853 56.817546889498 1.0035080977395)
            (CreateSketchLine 56.817546889498 1.0035080977395 55.235432944127 1.0587139975337)
            (CreateSketchArc3Points 55.235432944127 1.0587139975337 54.896458078918 1.2067682721722 54.750656788724 1.5467182850572)
            (CreateSketchArc3Points 54.750656788724 1.5467182850572 54.63411327277 3.8910696663193 54.417233796092 6.2282760240298)
            (CreateSketchArc3Points 54.417233796092 6.2282760240298 54.535719370142 6.6133355073348 54.898953266078 6.7876096527691)
            (CreateSketchLine 54.898953266078 6.7876096527691 56.334872411024 6.8377081641829)
            (CreateSketchArc3Points 56.334872411024 6.8377081641829 57.243457712476 7.8686262621531 56.27398423542 8.8425053881352)
            (CreateSketchLine 56.27398423542 8.8425053881352 54.450887511619 8.9061499503591)
            (CreateSketchArc3Points 54.450887511619 8.9061499503591 54.138090174788 9.0296766266724 53.973251711411 9.3228137354902)
            (CreateSketchArc3Points 53.973251711411 9.3228137354902 53.514017270399 11.673761683084 52.952431867685 14.002382495425)
            (CreateSketchArc3Points 52.952431867685 14.002382495425 53.034786617895 14.430405171446 53.420695196254 14.633038547815)
            (CreateSketchLine 53.420695196254 14.633038547815 54.671572228487 14.676724629175)
            (CreateSketchArc3Points 54.671572228487 14.676724629175 55.579988706098 15.707727487375 54.61048339773 16.681507158275)
            (CreateSketchLine 54.61048339773 16.681507158275 52.494430332262 16.755305263219)
            (CreateSketchArc3Points 52.494430332262 16.755305263219 52.210216434149 16.855671137477 52.034563236831 17.100613585549)
            (CreateSketchArc3Points 52.034563236831 17.100613585549 51.326608518022 19.120826715593 50.540253771611 21.111833292047)
            (CreateSketchArc3Points 50.540253771611 21.111833292047 50.621546230078 22.041628365033 51.432542133949 22.503594798289)
            (CreateSketchLine 51.432542133949 22.503594798289 51.657912409771 22.511460801572)
            (CreateSketchArc3Points 51.657912409771 22.511460801572 52.688617734037 23.48555209942 51.719047635238 24.520511589222)
            (CreateSketchLine 51.719047635238 24.520511589222 49.520003933151 24.597064785609)
            (CreateSketchArc3Points 49.520003933151 24.597064785609 49.017413612077 24.752304226047 48.66208653106 25.140168867644)
            (CreateSketchArc3Points 48.66208653106 25.140168867644 47.56930605755 27.151203977966 46.393463476354 29.114829604829)
            (CreateSketchArc3Points 46.393463476354 29.114829604829 46.352821426436 30.11223398128 47.192105500142 30.652668476701)
            (CreateSketchArc3Points 47.192105500142 30.652668476701 48.144452393642 31.665076402566 47.174549398751 32.660678583387)
            (CreateSketchLine 47.174549398751 32.660678583387 44.362859694831 32.758821799543)
            (CreateSketchArc3Points 44.362859694831 32.758821799543 43.935828032074 32.870742981207 43.59795580136 33.154863989959)
            (CreateSketchArc3Points 43.59795580136 33.154863989959 42.224675072533 34.887011498106 40.782621729373 36.562337468068)
            (CreateSketchArc3Points 40.782621729373 36.562337468068 40.573385575445 37.538394455487 41.308837084974 38.213359704913)
            (CreateSketchArc3Points 41.308837084974 38.213359704913 42.087314385756 39.28780449071 41.121818454061 40.197901250094)
            (CreateSketchLine 41.121818454061 40.197901250094 37.419309481833 40.327184659009)
            (CreateSketchArc3Points 37.419309481833 40.327184659009 37.076417480806 40.400353467214 36.779526778814 40.586859525916)
            (CreateSketchArc3Points 36.779526778814 40.586859525916 35.006949044224 42.125292578985 33.170089694982 43.586372937844)
            (CreateSketchArc3Points 33.170089694982 43.586372937844 32.780840638253 44.505585743802 33.376071173774 45.306939273122)
            (CreateSketchArc3Points 33.376071173774 45.306939273122 33.96059395501 46.416241789183 33.008479486307 47.232144254211)
            (CreateSketchLine 33.008479486307 47.232144254211 27.646697423588 47.419265232814)
            (CreateSketchArc3Points 27.646697423588 47.419265232814 27.406812591595 47.456992181193 27.182979212921 47.551155583854)
            (CreateSketchArc3Points 27.182979212921 47.551155583854 26.914924398965 47.703391921833 26.646016892446 47.854117273412)
            (CreateSketchArc3Points 26.646016892446 47.854117273412 26.268508834734 48.222928621746 26.129934633591 48.73217447109)
            (CreateSketchLine 26.129934633591 48.73217447109 26.129934633591 50.921409700712)
            (CreateSketchArc3Points 26.129934633591 50.921409700712 25.97843845728 51.452028417823 25.56962384566 51.822673538148)
            (CreateSketchArc3Points 25.56962384566 51.822673538148 -2.2957472869682e-14 57.7875 -25.569623742151 51.82267358922)
            (CreateSketchArc3Points -25.569623742151 51.82267358922 -25.97843845728 51.452028417823 -26.129934633591 50.921409700712)
            (CreateSketchLine -26.129934633591 50.921409700712 -26.129934633591 48.73217447109)
            (CreateSketchArc3Points -26.129934633591 48.73217447109 -26.268508834734 48.222928621746 -26.646016892446 47.854117273412)
            (CreateSketchArc3Points -26.646016892446 47.854117273412 -26.914924398964 47.703391921833 -27.182979343574 47.551155509165)
            (CreateSketchArc3Points -27.182979343574 47.551155509165 -27.406812591595 47.456992181193 -27.646697423588 47.419265232814)
            (CreateSketchLine -27.646697423588 47.419265232814 -33.008479486307 47.232144254211)
            (CreateSketchArc3Points -33.008479486307 47.232144254211 -33.96059395501 46.416241789183 -33.376071248555 45.306939305822)
            (CreateSketchArc3Points -33.376071248555 45.306939305822 -32.780840638253 44.505585743802 -33.170089630034 43.586372987271)
            (CreateSketchArc3Points -33.170089630034 43.586372987271 -35.006949044224 42.125292578985 -36.779526778814 40.586859525916)
            (CreateSketchArc3Points -36.779526778814 40.586859525916 -37.076417480806 40.400353467214 -37.419309481833 40.327184659009)
            (CreateSketchLine -37.419309481833 40.327184659009 -41.121818454061 40.197901250094)
            (CreateSketchArc3Points -41.121818454061 40.197901250094 -42.087314385756 39.28780449071 -41.308837084974 38.213359704913)
            (CreateSketchArc3Points -41.308837084974 38.213359704913 -40.573385575445 37.538394455487 -40.782621729373 36.562337468068)
            (CreateSketchArc3Points -40.782621729373 36.562337468068 -42.224675072533 34.887011498106 -43.59795580136 33.154863989959)
            (CreateSketchArc3Points -43.59795580136 33.154863989959 -43.935828032074 32.870742981207 -44.362859694831 32.758821799543)
            (CreateSketchLine -44.362859694831 32.758821799543 -47.174549398751 32.660678583387)
            (CreateSketchArc3Points -47.174549398751 32.660678583387 -48.144452393642 31.665076402566 -47.192104948318 30.652668447772)
            (CreateSketchArc3Points -47.192104948318 30.652668447772 -46.352821426436 30.11223398128 -46.393463476354 29.114829604829)
            (CreateSketchArc3Points -46.393463476354 29.114829604829 -47.56930605755 27.151203977966 -48.66208653106 25.140168867644)
            (CreateSketchArc3Points -48.66208653106 25.140168867644 -49.017413612077 24.752304226047 -49.520003933151 24.597064785609)
            (CreateSketchLine -49.520003933151 24.597064785609 -51.719047635238 24.520511589222)
            (CreateSketchArc3Points -51.719047635238 24.520511589222 -52.688617734037 23.48555209942 -51.657912409771 22.511460801572)
            (CreateSketchLine -51.657912409771 22.511460801572 -51.432542133949 22.503594798289)
            (CreateSketchArc3Points -51.432542133949 22.503594798289 -50.621546230078 22.041628365033 -50.540253771611 21.111833292047)
            (CreateSketchArc3Points -50.540253771611 21.111833292047 -51.326608518022 19.120826715593 -52.034563236831 17.100613585549)
            (CreateSketchArc3Points -52.034563236831 17.100613585549 -52.210216434149 16.855671137477 -52.494430332262 16.755305263219)
            (CreateSketchLine -52.494430332262 16.755305263219 -54.61048339773 16.681507158275)
            (CreateSketchArc3Points -54.61048339773 16.681507158275 -55.579988706098 15.707727487375 -54.671572228487 14.676724629175)
            (CreateSketchLine -54.671572228487 14.676724629175 -53.420695196254 14.633038547815)
            (CreateSketchArc3Points -53.420695196254 14.633038547815 -53.034786617895 14.430405171446 -52.952431883621 14.00238243516)
            (CreateSketchArc3Points -52.952431883621 14.00238243516 -53.514017270399 11.673761683084 -53.973251567854 9.3228145665987)
            (CreateSketchArc3Points -53.973251567854 9.3228145665987 -54.138090174787 9.0296766266724 -54.450887511619 8.9061499503591)
            (CreateSketchLine -54.450887511619 8.9061499503591 -56.17348423542 8.8425053881352)
            (CreateSketchArc3Points -56.17348423542 8.8425053881352 -57.142957712476 7.8686262621531 -56.234372411024 6.8377081641829)
            (CreateSketchLine -56.234372411024 6.8377081641829 -54.898953266078 6.7876096527691)
            (CreateSketchArc3Points -54.898953266078 6.7876096527691 -54.535719370143 6.6133355073348 -54.417233917073 6.2282749669979)
            (CreateSketchArc3Points -54.417233917073 6.2282749669979 -54.63411327277 3.8910696663193 -54.750656788724 1.5467182850571)
            (CreateSketchArc3Points -54.750656788724 1.5467182850571 -54.896458078918 1.2067682721722 -55.235432944127 1.0587139975337)
            (CreateSketchLine -55.235432944127 1.0587139975337 -56.817546889498 1.0035080977395)
            ;"Source Feature Name: Cut extrude 2"
            (CreateExtrudeCut
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                60
                :BOTH_SIDES
            )
            ;"Source Sketch Name: Sketch 2"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 52.5 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchCircle 0 0 57.5)
            ;"Source Feature Name: Base extrude 2"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                8
                :-W
            )
            ;"Source Sketch Name: Sketch 3"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x -52.5 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchCircle 0 0 57.5)
            ;"Source Feature Name: Base extrude 3"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                8
                :+W
            )
            ;"Source Sketch Name: Sketch 10"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchArc3Points -22.5 -25 -21.914213562373 -26.414213562373 -20.5 -27)
            (CreateSketchLine -20.5 -27 44.5 -27)
            (CreateSketchLine 44.5 -27 44.5 27)
            (CreateSketchLine 44.5 27 -20.5 27)
            (CreateSketchArc3Points -20.5 27 -21.914213562373 26.414213562373 -22.5 25)
            (CreateSketchLine -22.5 25 -22.5 -25)
            ;"Source Feature Name: Base extrude 5"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                49
                :+W
            )
            ;"Source Sketch Name: Sketch 4"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 56)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchArc3Points -22.5 -25 -21.914213562373 -26.414213562373 -20.5 -27)
            (CreateSketchLine -20.5 -27 42.5 -27)
            (CreateSketchArc3Points 42.5 -27 43.914213562373 -26.414213562373 44.5 -25)
            (CreateSketchLine 44.5 -25 44.5 25)
            (CreateSketchArc3Points 44.5 25 43.914213562373 26.414213562373 42.5 27)
            (CreateSketchLine 42.5 27 -20.5 27)
            (CreateSketchArc3Points -20.5 27 -21.914213562373 26.414213562373 -22.5 25)
            (CreateSketchLine -22.5 25 -22.5 -25)
            ;"Source Feature Name: Base extrude 4"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                10
                :-W
            )
            ;"Source Sketch Name: Sketch 5"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 56)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchArc3Points -22.5 -25 -21.914213562373 -26.414213562373 -20.5 -27)
            (CreateSketchLine -20.5 -27 42.5 -27)
            (CreateSketchArc3Points 42.5 -27 43.914213562373 -26.414213562373 44.5 -25)
            (CreateSketchLine 44.5 -25 44.5 25)
            (CreateSketchArc3Points 44.5 25 43.914213562373 26.414213562373 42.5 27)
            (CreateSketchLine 42.5 27 -20.5 27)
            (CreateSketchArc3Points -20.5 27 -21.914213562373 26.414213562373 -22.5 25)
            (CreateSketchLine -22.5 25 -22.5 -25)
            ;"Source Feature Name: Cut extrude 1"
            (CreateExtrudeCut
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                3
                :+W
            )

        ;;;;;********** Leave Part Geometry Processing **********

        ;;;;;********** Enter Connection Points Processing **********


        ;;;;;********** Leave Connection Points Processing **********

        ;;;;;********** Enter Surface Color Processing **********


        ;;;;;********** Leave Surface Color Processing **********

        ;;;;;********** Enter Negative Feature Processing **********

        (oli::sd-attach-item-attribute (oli::sd-pathname-to-obj *ObjectPathName*) "PARTsolutions-Negative" :attachment :contents :on-copy :copy :on-xform :maintain :on-merge :detach :values '("IsNegative" "0") :set-modified nil :check-read-only nil)

        ;;;;;********** Leave Negative Feature Processing **********

        ;;;;;********** Enter Physical Properties Processing **********


        (if (not (oli::sd-inq-empty-part-p (oli::sd-pathname-to-obj *ObjectPathName*)))
            (progn
                (oli::assign_mp_data :parcel (oli::sd-pathname-to-obj *ObjectPathName*)
                    :wetted_area (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :area))
                    :solid_volume (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :volume))
                    :centroid (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :centroid))
                    :prin_1 (first (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :principal)))
                    :prin_2 (second (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :principal)))
                    :prin_3 (third (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :principal)))
                    :mmi_1 (oli::gpnt3d_x (first (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :inertia_ref_coord))))
                    :mmi_2 (oli::gpnt3d_y (second (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :inertia_ref_coord))))
                    :mmi_3 (oli::gpnt3d_z (third (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :inertia_ref_coord))))
                )
            )
        )

        ;;;;;********** Leave Physical Properties Processing **********

        ;;;;;********** Enter Document Properties Processing **********

        (aftercreate_3)

        (setq name-in-library (oli::sd-set-library-attr (oli::sd-pathname-to-obj *ObjectPathName*) "PSOL" "T010"))

        ;;;;;********** Leave Document Properties Processing **********

    )

    ;;;;;**********End PartCreate**********


    (Log 1 "Leave GenerateObject_3")
)

(defun CreateNewPart_3()
    (Log 1 "Enter CreateNewPart_3")
    (GenerateObject_3)
    (Log 1 "Leave CreateNewPart_3")
    (return-from CreateNewPart_3 t)
)

(defun BuildPart_3()
    (Log 2 "Enter BuildPart_3")
    (Log 2 "Part Name:     T010")
    (Log 2 "Pool Path:     \\10.0.0.236\data_v9/pool/onespacemodeller/")
    (Log 2 "File Name:     T010")
    (Log 2 "Display Name:  T010")
    (Log 2 "ObjectPath:    /T010")

    (OnOpen_3)

	 (if (= *OnOpenValue* 1)
        (progn
            (Log 2 "Loaded Part From Session After OnOpen")
            (Log 2 "Leave BuildPart_3")
	         (return-from BuildPart_3 t)
        )
	 )

	 (if (not (CreateNewPart_3))
		 (progn
			 (Log 4 "Part Creation Failed. Aborting With Fatal Error")
            (Log 2 "Leave BuildPart_3")
			 (return-from BuildPart_3 nil)
		 )
        (progn
            (Log 2 "Part Creation Succeeded")
        )
	 )

	 (beforesave_3)
	 (onsave_3)
	 (aftersave_3)

    (Log 2 "Leave BuildPart_3")
	 (return-from BuildPart_3 t)
)

    ;;;;;********** Enter Part Creation Main "T010" **********
    (BuildPart_3)
    ;;;;;********** Leave Part Creation Main "T010" **********

    (transform-document (oli::sd-inq-curr-part) 0 0 0 1 0 0 0 1 0 185 -8.5 0 186 -8.5 0 185 -9.5 0)
        (let
            (
                (volLocal 0)
                (surfaceLocal 0)
                (massLocal 0)
            )
            (if (HasGeometry (oli::sd-pathname-to-obj *ObjectPathName*))
                (progn
                    (setf volLocal (oli::sd-call-cmds (oli::get_vol_prop :for_part (oli::sd-pathname-to-obj *ObjectPathName*) :volume)))
                    (setf surfaceLocal (oli::sd-call-cmds (oli::get_vol_prop :for_part (oli::sd-pathname-to-obj *ObjectPathName*) :area)))
                    (setf massLocal (oli::sd-call-cmds (oli::get_vol_prop :for_part (oli::sd-pathname-to-obj *ObjectPathName*) :mass)))
                )
            )

            (setf volTotal (+ volTotal volLocal))
            (setf surfaceTotal (+ surfaceTotal surfaceLocal))
            (setf massTotal (+ massTotal massLocal))
        )

        (defparameter *ObjectParentName* SAVEPARENT)
        (defparameter *ObjectAsmName* SAVEASM)
        (defparameter *ObjectPathName* SAVEPATH)
    )


    (let ((SAVEPARENT *ObjectParentName*) (SAVEASM *ObjectAsmName*) (SAVEPATH *ObjectPathName*))
(defun onopen_4()
    (Log 2 (concatenate 'string "Calling Callback " "DocOnOpen"))
        (Log 2 "Enter Callback SessionPartOnOpen")
    (Log 2 "Content Name:      010V")

    (defparameter *OnOpenValue* 0)
    (defparameter *OnOpenName* nil)

    (let
        (
            (fileName "010V")
            (displayName (oli::sd-gen-obj-basename :part :parent *ObjectParentName* :prefix "010V."))
        )
        (PartExists "010V")

        (if (not (= *PartExistsValue* 0))
            (progn
                (Log 2 (concatenate 'string "Found Content At:  " *PartExistsName*))

                (oli::create_MULTIPLE_PA :share :owner *ObjectParentName* :name displayName :source *PartExistsName*)

                (let (tVec xVec zVec tx ty tz xx xy xz zx zy zz)
                   (setf tVec (oli::sd-vec-xform 0,0,0 :source-space (oli::sd-inq-curr-part) :dest-space :global))
                   (setf xVec (oli::sd-vec-xform 1,0,0 :source-space (oli::sd-inq-curr-part) :dest-space :global))
                   (setf zVec (oli::sd-vec-xform 0,0,1 :source-space (oli::sd-inq-curr-part) :dest-space :global))

                   (setf tx   (oli::gpnt3d_x tVec))
                   (setf ty   (oli::gpnt3d_y tVec))
                   (setf tz   (oli::gpnt3d_z tVec))

                   (setf xx   (oli::gpnt3d_x xVec))
                   (setf xy   (oli::gpnt3d_y xVec))
                   (setf xz   (oli::gpnt3d_z xVec))

                   (setf zx   (oli::gpnt3d_x zVec))
                   (setf zy   (oli::gpnt3d_y zVec))
                   (setf zz   (oli::gpnt3d_z zVec))

                   (transform-document (oli::sd-inq-curr-part) tx ty tz xx xy xz zx zy zz 0 0 0 1 0 0 0 0 1)
                )

                (defparameter *OnOpenValue* 1)
                (defparameter *OnOpenName* (concatenate 'string *ObjectParentName* "/" displayName))
                (defparameter *ObjectPathName* *OnOpenName*)
                (Log 2 (concatenate 'string "New Instance Path: " *ObjectPathName*))
            )
            (progn
                (Log 2 "Content Not Found In Session")
            )
        )
    )

    (Log 2 "Leave Callback SessionPartOnOpen")
    (Log 2 (concatenate 'string "Called Callback " "DocOnOpen"))
)

(defun beforecreate_4()
    (Log 2 (concatenate 'string "Calling Callback " "DocBeforeCreate"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocBeforeCreate"))
)

(defun aftercreate_4()
    (Log 2 (concatenate 'string "Calling Callback " "DocAfterCreate"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocAfterCreate"))
)

(defun beforesave_4()
    (Log 2 (concatenate 'string "Calling Callback " "DocBeforeSave"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocBeforeSave"))
)

(defun onsave_4()
    (Log 2 (concatenate 'string "Calling Callback " "DocOnSave"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocOnSave"))
)

(defun aftersave_4()
    (Log 2 (concatenate 'string "Calling Callback " "DocAfterSave"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocAfterSave"))
)

(defun GenerateObject_4()
    (Log 1 "Enter GenerateObject_4")

    ;;;;;********** Enter CreatePart **********

    (defparameter *ObjectPartName* "010V" "010V")

    (if (string= *ObjectParentName* "/")
        (defparameter *ObjectPathName* (concatenate 'string *ObjectParentName* *ObjectPartName*))
        (defparameter *ObjectPathName* (concatenate 'string *ObjectParentName* "/" *ObjectPartName*))
    )

    (progn
        (oli::create_part :owner *ObjectParentName* :name *ObjectPartName*)
        (defparameter *ObjectPartName* "010V")
        (defparameter *ObjectPartModelName* "010V")
        (oli::change_name_pa :part_asmb *ObjectPathName* :name *ObjectPartModelName* :model_name *ObjectPartName*)
        (defparameter *ObjectPathName* (concatenate 'string *ObjectParentName* "/" *ObjectPartModelName*))

        (beforecreate_4)

        ;;;;;********** Enter Part Parameters Processing **********

        (oli::sd-attach-item-attribute (oli::sd-pathname-to-obj *ObjectPathName*) "PARTsolutions-attribute" :attachment :contents :on-copy :copy :on-xform :maintain :values '("mident" "{$CADENAS_DATA%5C23d-libs%5Cnissei%5Cinduction_gear_motor%5Cgtr_midi_series_01kw_to_22kw%5Cg3_series%5Cparts%5Cmotor_end.prj}%2C153%20{VTYP=3D}%2C{NB=010V}%2C{LINA=010V}%2C{NN=Motor%20end}%2C{DATE=17.03.2016%2004:21:33}%2C{GEOMDATE=11.02.2014%2009:42:00}%2C{VERSION=}%2C{LINEID=40}%2C{LINESUBID=-1}%2C{WBVAR=}%20%20{NB=010V}%2C{LINA=010V}%2C{KT=DUMMY}%2C{ME=010V}") :set-modified nil :check-read-only nil)
        (oli::sd-attach-item-attribute (oli::sd-pathname-to-obj *ObjectPathName*)  "DEFAULTATTR" :attachment :contents :on-copy :copy :on-xform :maintain :set-modified nil :check-read-only nil  :values '("NN" "Motor end" "NB" "010V" "NBSYN" "$ME." "LINA" "010V" "ME" "010V" "SUPPLIER" "NISSEI" "ARTICLENO" "010V" "BOMINFO" "010V" "CREATOR" "CADENAS GmbH" ))


        ;;;;;********** Leave Part Parameters Processing **********

        ;;;;;********** Enter Part Color Processing **********

        (oli::set_part_base_color :parts *ObjectPathName* :color :rgb (oli::gpnt3d 0.75294119119644 0.75294119119644 0.75294119119644))

        ;;;;;********** Leave Part Color Processing **********

        ;;;;;********** Enter Part Geometry Processing **********

            ;"Sketch Name: Sketch 1"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine -63 0 -63 25)
            (CreateSketchLine -63 25 -62.303847577293 26.20577136594)
            (CreateSketchArc3Points -62.303847577293 26.20577136594 -61.704445042266 27.652857095325 -61.5 29.20577136594)
            (CreateSketchLine -61.5 29.20577136594 -61.5 39.445839862997)
            (CreateSketchArc3Points -61.5 39.445839862997 -59.593362358904 44.15141887234 -54.948972244624 46.202609105836)
            (CreateSketchLine -54.948972244624 46.202609105836 -13 47.5)
            (CreateSketchLine -13 47.5 -13 46.5)
            (CreateSketchLine -13 46.5 -9.8256885145047 46.777716269481)
            (CreateSketchArc3Points -9.8256885145047 46.777716269481 -8.5254453263798 47.418925250433 -8 48.770105665664)
            (CreateSketchLine -8 48.770105665664 -8 58.5)
            (CreateSketchLine -8 58.5 0 58.5)
            (CreateSketchLine 0 58.5 0 0)
            (CreateSketchLine 0 0 -63 0)
            ;"Feature Name: Base rotate 1"
            (CreateRevolveBase
                *ObjectPathName* 
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x -63 :y 0 :z 0)
                180
                :BOTH_SIDES
            )
            ;"Source Sketch Name: Sketch 5"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x -8 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine -15 53 -15 -53)
            (CreateSketchLine -15 -53 -10.438909193333 -57.561090806667)
            (CreateSketchArc3Points -10.438909193333 -57.561090806667 -1.7851703020119e-14 -58.5 10.438909193333 -57.561090806667)
            (CreateSketchLine 10.438909193333 -57.561090806667 15 -53)
            (CreateSketchLine 15 -53 15 53)
            (CreateSketchLine 15 53 10.438909193333 57.561090806667)
            (CreateSketchArc3Points 10.438909193333 57.561090806667 3.582091887506e-15 58.5 -10.438909193333 57.561090806667)
            (CreateSketchLine -10.438909193333 57.561090806667 -15 53)
            ;"Source Feature Name: Base extrude 1"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                15
                :-W
            )
            ;"Sketch Name: Sketch 10"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine -25 65 -25 57.75)
            (CreateSketchLine -25 57.75 0 57.75)
            (CreateSketchLine 0 57.75 0 65)
            (CreateSketchLine 0 65 -25 65)
            ;"Source Feature Name: Cut rotate 1"
            (CreateRevolveCut
                *ObjectPathName* 
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x -25 :y 0 :z 0)
                360
                :-W
            )
            ;"Sketch Name: Sketch 11_ALT_Drilling 1"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0.98480775301221 :z 0.17364817766693)
            )
            (CreateSketchLine -23 52.5 -23 56.75)
            (CreateSketchLine -23 56.75 -21 56.75)
            (CreateSketchLine -21 56.75 -21 52.5)
            (CreateSketchLine -21 52.5 -23 52.5)
            ;"Source Feature Name: Cut rotate 2_ALT_Drilling 1"
            (CreateRevolveCut
                *ObjectPathName* 
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x -21 :y 51.702407033141 :z 9.1165293275138)
                (oli::make-gpnt3d :x -23 :y 51.702407033141 :z 9.1165293275138)
                360
                :-W
            )
            ;"Sketch Name: Sketch 12_ALT_Drilling 2"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0.98480775301221 :z 0.17364817766693)
            )
            (CreateSketchLine -21 -52.5 -21 -56.75)
            (CreateSketchLine -21 -56.75 -23 -56.75)
            (CreateSketchLine -23 -56.75 -23 -52.5)
            (CreateSketchLine -23 -52.5 -21 -52.5)
            ;"Source Feature Name: Cut rotate 3_ALT_Drilling 2"
            (CreateRevolveCut
                *ObjectPathName* 
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x -23 :y -51.702407033141 :z -9.1165293275138)
                (oli::make-gpnt3d :x -21 :y -51.702407033141 :z -9.1165293275138)
                360
                :-W
            )
            ;"Sketch Name: Sketch 13"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0.98480775301221 :z 0.17364817766693)
            )
            (CreateSketchLine -26 52.5 -26 56)
            (CreateSketchLine -26 56 -21 56)
            (CreateSketchLine -21 56 -21 52.5)
            (CreateSketchLine -21 52.5 -26 52.5)
            ;"Feature Name: Base rotate 2"
            (CreateRevolveBase
                *ObjectPathName* 
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x -21 :y 51.702407033141 :z 9.1165293275138)
                (oli::make-gpnt3d :x -26 :y 51.702407033141 :z 9.1165293275138)
                180
                :BOTH_SIDES
            )
            ;"Sketch Name: Sketch 14"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0.98480775301221 :z 0.17364817766693)
            )
            (CreateSketchLine -21 -52.5 -21 -56)
            (CreateSketchLine -21 -56 -26 -56)
            (CreateSketchLine -26 -56 -26 -52.5)
            (CreateSketchLine -26 -52.5 -21 -52.5)
            ;"Feature Name: Base rotate 6"
            (CreateRevolveBase
                *ObjectPathName* 
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x -26 :y -51.702407033141 :z -9.1165293275138)
                (oli::make-gpnt3d :x -21 :y -51.702407033141 :z -9.1165293275138)
                180
                :BOTH_SIDES
            )
            ;"Sketch Name: Sketch 9"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0.86602540378444 :z 0.5)
            )
            (CreateSketchLine -10.3 52 -10.3 56.4)
            (CreateSketchLine -10.3 56.4 -4.3 56.4)
            (CreateSketchLine -4.3 56.4 -4.3 52)
            (CreateSketchLine -4.3 52 -10.3 52)
            ;"Feature Name: Base rotate 5"
            (CreateRevolveBase
                *ObjectPathName* 
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x -4.3 :y 45.033320996791 :z 26)
                (oli::make-gpnt3d :x -10.3 :y 45.033320996791 :z 26)
                180
                :BOTH_SIDES
            )
            ;"Sketch Name: Sketch 6"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y -0.86602540378444 :z 0.5)
            )
            (CreateSketchLine -10.3 52 -10.3 56.4)
            (CreateSketchLine -10.3 56.4 -4.5 56.4)
            (CreateSketchLine -4.5 56.4 -4.5 52)
            (CreateSketchLine -4.5 52 -10.3 52)
            ;"Feature Name: Base rotate 3"
            (CreateRevolveBase
                *ObjectPathName* 
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x -4.5 :y -45.033320996791 :z 26)
                (oli::make-gpnt3d :x -10.3 :y -45.033320996791 :z 26)
                180
                :BOTH_SIDES
            )
            ;"Sketch Name: Sketch 7"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 6.1232339957368e-17 :z -1)
            )
            (CreateSketchLine -10.3 52 -10.3 56.4)
            (CreateSketchLine -10.3 56.4 -4.5 56.4)
            (CreateSketchLine -4.5 56.4 -4.5 52)
            (CreateSketchLine -4.5 52 -10.3 52)
            ;"Feature Name: Base rotate 4"
            (CreateRevolveBase
                *ObjectPathName* 
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x -4.5 :y 3.1840816777831e-15 :z -52)
                (oli::make-gpnt3d :x -10.3 :y 3.1840816777831e-15 :z -52)
                180
                :BOTH_SIDES
            )
            ;"Source Sketch Name: Sketch 2"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x -8 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine -33.89711431703 49.711524227066 -29.89711431703 42.783320996791)
            (CreateSketchArc3Points -29.89711431703 42.783320996791 -23.75 41.136206679761 -22.10288568297 47.283320996791)
            (CreateSketchLine -22.10288568297 47.283320996791 -26.10288568297 54.211524227066)
            (CreateSketchLine -26.10288568297 54.211524227066 -33.89711431703 49.711524227066)
            (CreateSketchLine -30.041451884327 45.033320996791 -28.020725942164 41.533320996791)
            (CreateSketchLine -28.020725942164 41.533320996791 -23.979274057836 41.533320996791)
            (CreateSketchLine -23.979274057836 41.533320996791 -21.958548115673 45.033320996791)
            (CreateSketchLine -21.958548115673 45.033320996791 -23.979274057836 48.533320996791)
            (CreateSketchLine -23.979274057836 48.533320996791 -28.020725942164 48.533320996791)
            (CreateSketchLine -28.020725942164 48.533320996791 -30.041451884327 45.033320996791)
            ;"Source Feature Name: Cut extrude 1"
            (CreateExtrudeCut
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                3.5
                :BOTH_SIDES
            )
            ;"Source Sketch Name: Sketch 3"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x -8 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchArc3Points 52 4.5 47.5 3.7351727373994e-15 52 -4.5)
            (CreateSketchLine 52 -4.5 60 -4.5)
            (CreateSketchLine 60 -4.5 60 4.5)
            (CreateSketchLine 60 4.5 52 4.5)
            (CreateSketchLine 47.958548115673 3.1086244689504e-15 49.979274057836 -3.5)
            (CreateSketchLine 49.979274057836 -3.5 54.020725942164 -3.5)
            (CreateSketchLine 54.020725942164 -3.5 56.041451884327 3.5527136788005e-15)
            (CreateSketchLine 56.041451884327 3.5527136788005e-15 54.020725942164 3.5)
            (CreateSketchLine 54.020725942164 3.5 49.979274057836 3.5)
            (CreateSketchLine 49.979274057836 3.5 47.958548115673 3.1086244689504e-15)
            ;"Source Feature Name: Cut extrude 2"
            (CreateExtrudeCut
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                3.5
                :BOTH_SIDES
            )
            ;"Source Sketch Name: Sketch 4"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x -8 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine -33.89711431703 -49.711524227066 -26.10288568297 -54.211524227066)
            (CreateSketchLine -26.10288568297 -54.211524227066 -22.10288568297 -47.283320996791)
            (CreateSketchArc3Points -22.10288568297 -47.283320996791 -23.75 -41.136206679761 -29.89711431703 -42.783320996791)
            (CreateSketchLine -29.89711431703 -42.783320996791 -33.89711431703 -49.711524227066)
            (CreateSketchLine -30.041451884327 -45.033320996791 -28.020725942164 -48.533320996791)
            (CreateSketchLine -28.020725942164 -48.533320996791 -23.979274057836 -48.533320996791)
            (CreateSketchLine -23.979274057836 -48.533320996791 -21.958548115673 -45.033320996791)
            (CreateSketchLine -21.958548115673 -45.033320996791 -23.979274057836 -41.533320996791)
            (CreateSketchLine -23.979274057836 -41.533320996791 -28.020725942164 -41.533320996791)
            (CreateSketchLine -28.020725942164 -41.533320996791 -30.041451884327 -45.033320996791)
            ;"Source Feature Name: Cut extrude 3"
            (CreateExtrudeCut
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                3.5
                :BOTH_SIDES
            )

        ;;;;;********** Leave Part Geometry Processing **********

        ;;;;;********** Enter Connection Points Processing **********


        ;;;;;********** Leave Connection Points Processing **********

        ;;;;;********** Enter Surface Color Processing **********


        ;;;;;********** Leave Surface Color Processing **********

        ;;;;;********** Enter Negative Feature Processing **********

        (oli::sd-attach-item-attribute (oli::sd-pathname-to-obj *ObjectPathName*) "PARTsolutions-Negative" :attachment :contents :on-copy :copy :on-xform :maintain :on-merge :detach :values '("IsNegative" "0") :set-modified nil :check-read-only nil)

        ;;;;;********** Leave Negative Feature Processing **********

        ;;;;;********** Enter Physical Properties Processing **********


        (if (not (oli::sd-inq-empty-part-p (oli::sd-pathname-to-obj *ObjectPathName*)))
            (progn
                (oli::assign_mp_data :parcel (oli::sd-pathname-to-obj *ObjectPathName*)
                    :wetted_area (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :area))
                    :solid_volume (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :volume))
                    :centroid (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :centroid))
                    :prin_1 (first (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :principal)))
                    :prin_2 (second (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :principal)))
                    :prin_3 (third (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :principal)))
                    :mmi_1 (oli::gpnt3d_x (first (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :inertia_ref_coord))))
                    :mmi_2 (oli::gpnt3d_y (second (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :inertia_ref_coord))))
                    :mmi_3 (oli::gpnt3d_z (third (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :inertia_ref_coord))))
                )
            )
        )

        ;;;;;********** Leave Physical Properties Processing **********

        ;;;;;********** Enter Document Properties Processing **********

        (aftercreate_4)

        (setq name-in-library (oli::sd-set-library-attr (oli::sd-pathname-to-obj *ObjectPathName*) "PSOL" "010V"))

        ;;;;;********** Leave Document Properties Processing **********

    )

    ;;;;;**********End PartCreate**********


    (Log 1 "Leave GenerateObject_4")
)

(defun CreateNewPart_4()
    (Log 1 "Enter CreateNewPart_4")
    (GenerateObject_4)
    (Log 1 "Leave CreateNewPart_4")
    (return-from CreateNewPart_4 t)
)

(defun BuildPart_4()
    (Log 2 "Enter BuildPart_4")
    (Log 2 "Part Name:     010V")
    (Log 2 "Pool Path:     \\10.0.0.236\data_v9/pool/onespacemodeller/")
    (Log 2 "File Name:     010V")
    (Log 2 "Display Name:  010V")
    (Log 2 "ObjectPath:    /010V")

    (OnOpen_4)

	 (if (= *OnOpenValue* 1)
        (progn
            (Log 2 "Loaded Part From Session After OnOpen")
            (Log 2 "Leave BuildPart_4")
	         (return-from BuildPart_4 t)
        )
	 )

	 (if (not (CreateNewPart_4))
		 (progn
			 (Log 4 "Part Creation Failed. Aborting With Fatal Error")
            (Log 2 "Leave BuildPart_4")
			 (return-from BuildPart_4 nil)
		 )
        (progn
            (Log 2 "Part Creation Succeeded")
        )
	 )

	 (beforesave_4)
	 (onsave_4)
	 (aftersave_4)

    (Log 2 "Leave BuildPart_4")
	 (return-from BuildPart_4 t)
)

    ;;;;;********** Enter Part Creation Main "010V" **********
    (BuildPart_4)
    ;;;;;********** Leave Part Creation Main "010V" **********

    (transform-document (oli::sd-inq-curr-part) 0 0 0 1 0 0 0 1 0 237.5 -8.5 0 236.5 -8.5 0 237.5 -7.5 0)
        (let
            (
                (volLocal 0)
                (surfaceLocal 0)
                (massLocal 0)
            )
            (if (HasGeometry (oli::sd-pathname-to-obj *ObjectPathName*))
                (progn
                    (setf volLocal (oli::sd-call-cmds (oli::get_vol_prop :for_part (oli::sd-pathname-to-obj *ObjectPathName*) :volume)))
                    (setf surfaceLocal (oli::sd-call-cmds (oli::get_vol_prop :for_part (oli::sd-pathname-to-obj *ObjectPathName*) :area)))
                    (setf massLocal (oli::sd-call-cmds (oli::get_vol_prop :for_part (oli::sd-pathname-to-obj *ObjectPathName*) :mass)))
                )
            )

            (setf volTotal (+ volTotal volLocal))
            (setf surfaceTotal (+ surfaceTotal surfaceLocal))
            (setf massTotal (+ massTotal massLocal))
        )

        (defparameter *ObjectParentName* SAVEPARENT)
        (defparameter *ObjectAsmName* SAVEASM)
        (defparameter *ObjectPathName* SAVEPATH)
    )


    (let ((SAVEPARENT *ObjectParentName*) (SAVEASM *ObjectAsmName*) (SAVEPATH *ObjectPathName*))
(defun onopen_5()
    (Log 2 (concatenate 'string "Calling Callback " "DocOnOpen"))
        (Log 2 "Enter Callback SessionPartOnOpen")
    (Log 2 "Content Name:      E_BOX_aluminum_T010_")

    (defparameter *OnOpenValue* 0)
    (defparameter *OnOpenName* nil)

    (let
        (
            (fileName "E_BOX_aluminum_T010_")
            (displayName (oli::sd-gen-obj-basename :part :parent *ObjectParentName* :prefix "E_BOX_aluminum_T010_."))
        )
        (PartExists "E_BOX_aluminum_T010_")

        (if (not (= *PartExistsValue* 0))
            (progn
                (Log 2 (concatenate 'string "Found Content At:  " *PartExistsName*))

                (oli::create_MULTIPLE_PA :share :owner *ObjectParentName* :name displayName :source *PartExistsName*)

                (let (tVec xVec zVec tx ty tz xx xy xz zx zy zz)
                   (setf tVec (oli::sd-vec-xform 0,0,0 :source-space (oli::sd-inq-curr-part) :dest-space :global))
                   (setf xVec (oli::sd-vec-xform 1,0,0 :source-space (oli::sd-inq-curr-part) :dest-space :global))
                   (setf zVec (oli::sd-vec-xform 0,0,1 :source-space (oli::sd-inq-curr-part) :dest-space :global))

                   (setf tx   (oli::gpnt3d_x tVec))
                   (setf ty   (oli::gpnt3d_y tVec))
                   (setf tz   (oli::gpnt3d_z tVec))

                   (setf xx   (oli::gpnt3d_x xVec))
                   (setf xy   (oli::gpnt3d_y xVec))
                   (setf xz   (oli::gpnt3d_z xVec))

                   (setf zx   (oli::gpnt3d_x zVec))
                   (setf zy   (oli::gpnt3d_y zVec))
                   (setf zz   (oli::gpnt3d_z zVec))

                   (transform-document (oli::sd-inq-curr-part) tx ty tz xx xy xz zx zy zz 0 0 0 1 0 0 0 0 1)
                )

                (defparameter *OnOpenValue* 1)
                (defparameter *OnOpenName* (concatenate 'string *ObjectParentName* "/" displayName))
                (defparameter *ObjectPathName* *OnOpenName*)
                (Log 2 (concatenate 'string "New Instance Path: " *ObjectPathName*))
            )
            (progn
                (Log 2 "Content Not Found In Session")
            )
        )
    )

    (Log 2 "Leave Callback SessionPartOnOpen")
    (Log 2 (concatenate 'string "Called Callback " "DocOnOpen"))
)

(defun beforecreate_5()
    (Log 2 (concatenate 'string "Calling Callback " "DocBeforeCreate"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocBeforeCreate"))
)

(defun aftercreate_5()
    (Log 2 (concatenate 'string "Calling Callback " "DocAfterCreate"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocAfterCreate"))
)

(defun beforesave_5()
    (Log 2 (concatenate 'string "Calling Callback " "DocBeforeSave"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocBeforeSave"))
)

(defun onsave_5()
    (Log 2 (concatenate 'string "Calling Callback " "DocOnSave"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocOnSave"))
)

(defun aftersave_5()
    (Log 2 (concatenate 'string "Calling Callback " "DocAfterSave"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocAfterSave"))
)

(defun GenerateObject_5()
    (Log 1 "Enter GenerateObject_5")

    ;;;;;********** Enter CreatePart **********

    (defparameter *ObjectPartName* "E_BOX_aluminum_T010_" "E_BOX_aluminum_T010_")

    (if (string= *ObjectParentName* "/")
        (defparameter *ObjectPathName* (concatenate 'string *ObjectParentName* *ObjectPartName*))
        (defparameter *ObjectPathName* (concatenate 'string *ObjectParentName* "/" *ObjectPartName*))
    )

    (progn
        (oli::create_part :owner *ObjectParentName* :name *ObjectPartName*)
        (defparameter *ObjectPartName* "E_BOX_aluminum_T010_")
        (defparameter *ObjectPartModelName* "E_BOX_aluminum_T010_")
        (oli::change_name_pa :part_asmb *ObjectPathName* :name *ObjectPartModelName* :model_name *ObjectPartName*)
        (defparameter *ObjectPathName* (concatenate 'string *ObjectParentName* "/" *ObjectPartModelName*))

        (beforecreate_5)

        ;;;;;********** Enter Part Parameters Processing **********

        (oli::sd-attach-item-attribute (oli::sd-pathname-to-obj *ObjectPathName*) "PARTsolutions-attribute" :attachment :contents :on-copy :copy :on-xform :maintain :values '("mident" "{$CADENAS_DATA%5C23d-libs%5Cnissei%5Cinduction_gear_motor%5Cgtr_midi_series_01kw_to_22kw%5Cg3_series%5Cparts%5Cterminal.prj}%2C188%20{VTYP=3D}%2C{NB=E-BOX(aluminum)(T010)}%2C{LINA=E-BOX(aluminum)(T010)}%2C{NN=Terminal}%2C{DATE=17.03.2016%2004:21:33}%2C{GEOMDATE=24.02.2016%2013:23:00}%2C{VERSION=}%2C{LINEID=20}%2C{LINESUBID=-1}%2C{WBVAR=MC}%20%20{NB=E-BOX(aluminum)(T010)}%2C{LINA=E-BOX(aluminum)(T010)}%2C{KT=DUMMY}%2C{TI=E}%2C{TI1=E-BOX(aluminum)}%2C{MC=T010}%2C{L=0.3103}%2C{TI2=E-BOX}") :set-modified nil :check-read-only nil)
        (oli::sd-attach-item-attribute (oli::sd-pathname-to-obj *ObjectPathName*)  "DEFAULTATTR" :attachment :contents :on-copy :copy :on-xform :maintain :set-modified nil :check-read-only nil  :values '("NN" "Terminal" "NB" "E-BOX(aluminum)(T010)" "NBSYN" "$TI1.($MC.)" "LINA" "E-BOX(aluminum)(T010)" "TI" "E" "TI1" "E-BOX(aluminum)" "MC" "T010" "TI2" "E-BOX" "SUPPLIER" "NISSEI" "ARTICLENO" "E-BOX(aluminum)(T010)" "BOMINFO" "E-BOX(aluminum)(T010)" "CREATOR" "CADENAS GmbH" ))


        ;;;;;********** Leave Part Parameters Processing **********

        ;;;;;********** Enter Part Color Processing **********

        (oli::set_part_base_color :parts *ObjectPathName* :color :rgb (oli::gpnt3d 0.75294119119644 0.75294119119644 0.75294119119644))

        ;;;;;********** Leave Part Color Processing **********

        ;;;;;********** Enter Part Geometry Processing **********

            ;"Source Sketch Name: Sketch 1"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchArc3Points -40 -37.5 -39.267766952966 -39.267766952966 -37.5 -40)
            (CreateSketchLine -37.5 -40 37.5 -40)
            (CreateSketchArc3Points 37.5 -40 39.267766952966 -39.267766952966 40 -37.5)
            (CreateSketchLine 40 -37.5 40 37.5)
            (CreateSketchArc3Points 40 37.5 39.267766952966 39.267766952966 37.5 40)
            (CreateSketchLine 37.5 40 -37.5 40)
            (CreateSketchArc3Points -37.5 40 -39.267766952966 39.267766952966 -40 37.5)
            (CreateSketchLine -40 37.5 -40 -37.5)
            ;"Source Feature Name: Base extrude 1"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                52.5
                :+W
            )
            ;"Source Sketch Name: Sketch 2"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine -25 -60 75 -60)
            (CreateSketchLine 75 -60 75 60)
            (CreateSketchLine 75 60 -25 60)
            (CreateSketchLine -25 60 -25 -60)
            (CreateSketchLine 0 -24 0.4 -24)
            (CreateSketchLine 0.4 -24 0.4 -25.085)
            (CreateSketchLine 0.4 -25.085 3.3 -25.085)
            (CreateSketchLine 3.3 -25.085 11.91 -40)
            (CreateSketchLine 11.91 -40 40.2 -40)
            (CreateSketchLine 40.2 -40 40.2 -39)
            (CreateSketchLine 40.2 -39 42.7 -39)
            (CreateSketchLine 42.7 -39 42.7 -40)
            (CreateSketchLine 42.7 -40 50 -40)
            (CreateSketchArc3Points 50 -40 51.767766952966 -39.267766952966 52.5 -37.5)
            (CreateSketchLine 52.5 -37.5 52.5 37.5)
            (CreateSketchArc3Points 52.5 37.5 51.767766952966 39.267766952966 50 40)
            (CreateSketchLine 50 40 42.7 40)
            (CreateSketchLine 42.7 40 42.7 39)
            (CreateSketchLine 42.7 39 40.2 39)
            (CreateSketchLine 40.2 39 40.2 40)
            (CreateSketchLine 40.2 40 11.91 40)
            (CreateSketchLine 11.91 40 3.3 25.085)
            (CreateSketchLine 3.3 25.085 0.4 25.085)
            (CreateSketchLine 0.4 25.085 0.4 24)
            (CreateSketchLine 0.4 24 0 24)
            (CreateSketchLine 0 24 0 -24)
            ;"Source Feature Name: Cut extrude 1"
            (CreateExtrudeCut
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                40
                :BOTH_SIDES
            )
            ;"Source Sketch Name: Sketch 3"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
            )
            (CreateSketchLine -25 -60 75 -60)
            (CreateSketchLine 75 -60 75 60)
            (CreateSketchLine 75 60 -25 60)
            (CreateSketchLine -25 60 -25 -60)
            (CreateSketchLine 0 -24 0.4 -24)
            (CreateSketchLine 0.4 -24 0.4 -25.085)
            (CreateSketchLine 0.4 -25.085 3.3 -25.085)
            (CreateSketchLine 3.3 -25.085 11.91 -40)
            (CreateSketchLine 11.91 -40 40.2 -40)
            (CreateSketchLine 40.2 -40 40.2 -39)
            (CreateSketchLine 40.2 -39 42.7 -39)
            (CreateSketchLine 42.7 -39 42.7 -40)
            (CreateSketchLine 42.7 -40 50 -40)
            (CreateSketchArc3Points 50 -40 51.767766952966 -39.267766952966 52.5 -37.5)
            (CreateSketchLine 52.5 -37.5 52.5 37.5)
            (CreateSketchArc3Points 52.5 37.5 51.767766952966 39.267766952966 50 40)
            (CreateSketchLine 50 40 42.7 40)
            (CreateSketchLine 42.7 40 42.7 39)
            (CreateSketchLine 42.7 39 40.2 39)
            (CreateSketchLine 40.2 39 40.2 40)
            (CreateSketchLine 40.2 40 11.91 40)
            (CreateSketchLine 11.91 40 3.3 25.085)
            (CreateSketchLine 3.3 25.085 0.4 25.085)
            (CreateSketchLine 0.4 25.085 0.4 24)
            (CreateSketchLine 0.4 24 0 24)
            (CreateSketchLine 0 24 0 -24)
            ;"Source Feature Name: Cut extrude 2"
            (CreateExtrudeCut
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                40
                :BOTH_SIDES
            )
            ;"Source Sketch Name: Sketch 4"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 52.5 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine -50 -50 50 -50)
            (CreateSketchLine 50 -50 50 50)
            (CreateSketchLine 50 50 -50 50)
            (CreateSketchLine -50 50 -50 -50)
            (CreateSketchLine -40 -30 -35 -30)
            (CreateSketchArc3Points -35 -30 -31.464466094067 -31.464466094067 -30 -35)
            (CreateSketchLine -30 -35 -30 -40)
            (CreateSketchLine -30 -40 30 -40)
            (CreateSketchLine 30 -40 30 -35)
            (CreateSketchArc3Points 30 -35 31.464466094067 -31.464466094067 35 -30)
            (CreateSketchLine 35 -30 40 -30)
            (CreateSketchLine 40 -30 40 30)
            (CreateSketchLine 40 30 35 30)
            (CreateSketchArc3Points 35 30 31.464466094067 31.464466094067 30 35)
            (CreateSketchLine 30 35 30 40)
            (CreateSketchLine 30 40 -30 40)
            (CreateSketchLine -30 40 -30 35)
            (CreateSketchArc3Points -30 35 -31.464466094067 31.464466094067 -35 30)
            (CreateSketchLine -35 30 -40 30)
            (CreateSketchLine -40 30 -40 -30)
            ;"Source Feature Name: Cut extrude 3"
            (CreateExtrudeCut
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                3.6
                :-W
            )
            ;"Source Sketch Name: Sketch 5"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 52.5 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchCircle 35 35 3.5)
            ;"Source Feature Name: Base extrude 2"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                3.6
                :-W
            )
            ;"Source Sketch Name: Sketch 6"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 52.5 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchCircle -35 35 3.5)
            ;"Source Feature Name: Base extrude 3"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                3.6
                :-W
            )
            ;"Source Sketch Name: Sketch 7"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 52.5 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchCircle -35 -35 3.5)
            ;"Source Feature Name: Base extrude 4"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                3.6
                :-W
            )
            ;"Source Sketch Name: Sketch 8"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 52.5 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchCircle 35 -35 3.5)
            ;"Source Feature Name: Base extrude 5"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                3.6
                :-W
            )
            ;"Sketch Name: Sketch 9"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
            )
            (CreateSketchLine 27.7 -38 42.2 -38)
            (CreateSketchLine 42.2 -38 42.2 -44.5)
            (CreateSketchLine 42.2 -44.5 42.7 -44.5)
            (CreateSketchLine 42.7 -44.5 42.7 -49)
            (CreateSketchLine 42.7 -49 38.2 -49)
            (CreateSketchLine 38.2 -49 38.2 -51)
            (CreateSketchLine 38.2 -51 39.7 -51)
            (CreateSketchLine 39.7 -51 39.7 -60)
            (CreateSketchLine 39.7 -60 42.7 -60)
            (CreateSketchLine 42.7 -60 42.7 -68)
            (CreateSketchLine 42.7 -68 33.7 -68)
            (CreateSketchLine 33.7 -68 33.7 -63)
            (CreateSketchLine 33.7 -63 27.7 -63)
            (CreateSketchLine 27.7 -63 27.7 -38)
            ;"Feature Name: Base rotate 1"
            (CreateRevolveBase
                *ObjectPathName* 
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 27.7 :y 0 :z 63)
                (oli::make-gpnt3d :x 27.7 :y 0 :z 38)
                180
                :BOTH_SIDES
            )
            ;"Source Sketch Name: Sketch 10"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 68)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 1 :z 0)
            )
            (CreateSketchLine 0 -25 50 -25)
            (CreateSketchLine 50 -25 50 25)
            (CreateSketchLine 50 25 0 25)
            (CreateSketchLine 0 25 0 -25)
            (CreateSketchLine 15.7 -6.9282032302755 27.7 -13.856406460551)
            (CreateSketchLine 27.7 -13.856406460551 39.7 -6.9282032302755)
            (CreateSketchLine 39.7 -6.9282032302755 39.7 6.9282032302755)
            (CreateSketchLine 39.7 6.9282032302755 27.7 13.856406460551)
            (CreateSketchLine 27.7 13.856406460551 15.7 6.9282032302755)
            (CreateSketchLine 15.7 6.9282032302755 15.7 -6.9282032302755)
            ;"Source Feature Name: Cut extrude 4"
            (CreateExtrudeCut
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                23.5
                :-W
            )

        ;;;;;********** Leave Part Geometry Processing **********

        ;;;;;********** Enter Connection Points Processing **********


        ;;;;;********** Leave Connection Points Processing **********

        ;;;;;********** Enter Surface Color Processing **********


        ;;;;;********** Leave Surface Color Processing **********

        ;;;;;********** Enter Negative Feature Processing **********

        (oli::sd-attach-item-attribute (oli::sd-pathname-to-obj *ObjectPathName*) "PARTsolutions-Negative" :attachment :contents :on-copy :copy :on-xform :maintain :on-merge :detach :values '("IsNegative" "0") :set-modified nil :check-read-only nil)

        ;;;;;********** Leave Negative Feature Processing **********

        ;;;;;********** Enter Physical Properties Processing **********


        (if (not (oli::sd-inq-empty-part-p (oli::sd-pathname-to-obj *ObjectPathName*)))
            (progn
                (oli::assign_mp_data :parcel (oli::sd-pathname-to-obj *ObjectPathName*)
                    :wetted_area (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :area))
                    :solid_volume (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :volume))
                    :centroid (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :centroid))
                    :prin_1 (first (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :principal)))
                    :prin_2 (second (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :principal)))
                    :prin_3 (third (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :principal)))
                    :mmi_1 (oli::gpnt3d_x (first (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :inertia_ref_coord))))
                    :mmi_2 (oli::gpnt3d_y (second (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :inertia_ref_coord))))
                    :mmi_3 (oli::gpnt3d_z (third (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :inertia_ref_coord))))
                )
            )
        )

        ;;;;;********** Leave Physical Properties Processing **********

        ;;;;;********** Enter Document Properties Processing **********

        (aftercreate_5)

        (setq name-in-library (oli::sd-set-library-attr (oli::sd-pathname-to-obj *ObjectPathName*) "PSOL" "E_BOX_aluminum_T010_"))

        ;;;;;********** Leave Document Properties Processing **********

    )

    ;;;;;**********End PartCreate**********


    (Log 1 "Leave GenerateObject_5")
)

(defun CreateNewPart_5()
    (Log 1 "Enter CreateNewPart_5")
    (GenerateObject_5)
    (Log 1 "Leave CreateNewPart_5")
    (return-from CreateNewPart_5 t)
)

(defun BuildPart_5()
    (Log 2 "Enter BuildPart_5")
    (Log 2 "Part Name:     E_BOX_aluminum_T010_")
    (Log 2 "Pool Path:     \\10.0.0.236\data_v9/pool/onespacemodeller/")
    (Log 2 "File Name:     E_BOX_aluminum_T010_")
    (Log 2 "Display Name:  E_BOX_aluminum_T010_")
    (Log 2 "ObjectPath:    /E_BOX_aluminum_T010_")

    (OnOpen_5)

	 (if (= *OnOpenValue* 1)
        (progn
            (Log 2 "Loaded Part From Session After OnOpen")
            (Log 2 "Leave BuildPart_5")
	         (return-from BuildPart_5 t)
        )
	 )

	 (if (not (CreateNewPart_5))
		 (progn
			 (Log 4 "Part Creation Failed. Aborting With Fatal Error")
            (Log 2 "Leave BuildPart_5")
			 (return-from BuildPart_5 nil)
		 )
        (progn
            (Log 2 "Part Creation Succeeded")
        )
	 )

	 (beforesave_5)
	 (onsave_5)
	 (aftersave_5)

    (Log 2 "Leave BuildPart_5")
	 (return-from BuildPart_5 t)
)

    ;;;;;********** Enter Part Creation Main "E_BOX_aluminum_T010_" **********
    (BuildPart_5)
    ;;;;;********** Leave Part Creation Main "E_BOX_aluminum_T010_" **********

    (transform-document (oli::sd-inq-curr-part) 0 0 0 1 0 0 0 1 0 201.5 -8.5 -56 201.5 -8.5 -57 201.5 -7.5 -56)
        (let
            (
                (volLocal 0)
                (surfaceLocal 0)
                (massLocal 0)
            )
            (if (HasGeometry (oli::sd-pathname-to-obj *ObjectPathName*))
                (progn
                    (setf volLocal (oli::sd-call-cmds (oli::get_vol_prop :for_part (oli::sd-pathname-to-obj *ObjectPathName*) :volume)))
                    (setf surfaceLocal (oli::sd-call-cmds (oli::get_vol_prop :for_part (oli::sd-pathname-to-obj *ObjectPathName*) :area)))
                    (setf massLocal (oli::sd-call-cmds (oli::get_vol_prop :for_part (oli::sd-pathname-to-obj *ObjectPathName*) :mass)))
                )
            )

            (setf volTotal (+ volTotal volLocal))
            (setf surfaceTotal (+ surfaceTotal surfaceLocal))
            (setf massTotal (+ massTotal massLocal))
        )

        (defparameter *ObjectParentName* SAVEPARENT)
        (defparameter *ObjectAsmName* SAVEASM)
        (defparameter *ObjectPathName* SAVEPATH)
    )


    (let ((SAVEPARENT *ObjectParentName*) (SAVEASM *ObjectAsmName*) (SAVEPATH *ObjectPathName*))
(defun onopen_6()
    (Log 2 (concatenate 'string "Calling Callback " "DocOnOpen"))
        (Log 2 "Enter Callback SessionPartOnOpen")
    (Log 2 "Content Name:      KEY1_28")

    (defparameter *OnOpenValue* 0)
    (defparameter *OnOpenName* nil)

    (let
        (
            (fileName "KEY1_28")
            (displayName (oli::sd-gen-obj-basename :part :parent *ObjectParentName* :prefix "KEY1_28."))
        )
        (PartExists "KEY1_28")

        (if (not (= *PartExistsValue* 0))
            (progn
                (Log 2 (concatenate 'string "Found Content At:  " *PartExistsName*))

                (oli::create_MULTIPLE_PA :share :owner *ObjectParentName* :name displayName :source *PartExistsName*)

                (let (tVec xVec zVec tx ty tz xx xy xz zx zy zz)
                   (setf tVec (oli::sd-vec-xform 0,0,0 :source-space (oli::sd-inq-curr-part) :dest-space :global))
                   (setf xVec (oli::sd-vec-xform 1,0,0 :source-space (oli::sd-inq-curr-part) :dest-space :global))
                   (setf zVec (oli::sd-vec-xform 0,0,1 :source-space (oli::sd-inq-curr-part) :dest-space :global))

                   (setf tx   (oli::gpnt3d_x tVec))
                   (setf ty   (oli::gpnt3d_y tVec))
                   (setf tz   (oli::gpnt3d_z tVec))

                   (setf xx   (oli::gpnt3d_x xVec))
                   (setf xy   (oli::gpnt3d_y xVec))
                   (setf xz   (oli::gpnt3d_z xVec))

                   (setf zx   (oli::gpnt3d_x zVec))
                   (setf zy   (oli::gpnt3d_y zVec))
                   (setf zz   (oli::gpnt3d_z zVec))

                   (transform-document (oli::sd-inq-curr-part) tx ty tz xx xy xz zx zy zz 0 0 0 1 0 0 0 0 1)
                )

                (defparameter *OnOpenValue* 1)
                (defparameter *OnOpenName* (concatenate 'string *ObjectParentName* "/" displayName))
                (defparameter *ObjectPathName* *OnOpenName*)
                (Log 2 (concatenate 'string "New Instance Path: " *ObjectPathName*))
            )
            (progn
                (Log 2 "Content Not Found In Session")
            )
        )
    )

    (Log 2 "Leave Callback SessionPartOnOpen")
    (Log 2 (concatenate 'string "Called Callback " "DocOnOpen"))
)

(defun beforecreate_6()
    (Log 2 (concatenate 'string "Calling Callback " "DocBeforeCreate"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocBeforeCreate"))
)

(defun aftercreate_6()
    (Log 2 (concatenate 'string "Calling Callback " "DocAfterCreate"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocAfterCreate"))
)

(defun beforesave_6()
    (Log 2 (concatenate 'string "Calling Callback " "DocBeforeSave"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocBeforeSave"))
)

(defun onsave_6()
    (Log 2 (concatenate 'string "Calling Callback " "DocOnSave"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocOnSave"))
)

(defun aftersave_6()
    (Log 2 (concatenate 'string "Calling Callback " "DocAfterSave"))
    
    (Log 2 (concatenate 'string "Called Callback " "DocAfterSave"))
)

(defun GenerateObject_6()
    (Log 1 "Enter GenerateObject_6")

    ;;;;;********** Enter CreatePart **********

    (defparameter *ObjectPartName* "KEY1_28" "KEY1_28")

    (if (string= *ObjectParentName* "/")
        (defparameter *ObjectPathName* (concatenate 'string *ObjectParentName* *ObjectPartName*))
        (defparameter *ObjectPathName* (concatenate 'string *ObjectParentName* "/" *ObjectPartName*))
    )

    (progn
        (oli::create_part :owner *ObjectParentName* :name *ObjectPartName*)
        (defparameter *ObjectPartName* "KEY1_28")
        (defparameter *ObjectPartModelName* "KEY1_28")
        (oli::change_name_pa :part_asmb *ObjectPathName* :name *ObjectPartModelName* :model_name *ObjectPartName*)
        (defparameter *ObjectPathName* (concatenate 'string *ObjectParentName* "/" *ObjectPartModelName*))

        (beforecreate_6)

        ;;;;;********** Enter Part Parameters Processing **********

        (oli::sd-attach-item-attribute (oli::sd-pathname-to-obj *ObjectPathName*) "PARTsolutions-attribute" :attachment :contents :on-copy :copy :on-xform :maintain :values '("mident" "{$CADENAS_DATA%5C23d-libs%5Cnissei%5Cinduction_gear_motor%5Cgtr_midi_series_01kw_to_22kw%5Cg3_series%5Cparts%5Ckey1.prj}%2C155%20{VTYP=3D}%2C{NB=KEY1-28}%2C{LINA=KEY1-28}%2C{NN=Key1}%2C{DATE=17.03.2016%2004:21:33}%2C{GEOMDATE=08.01.2007%2000:00:00}%2C{VERSION=}%2C{LINEID=110}%2C{LINESUBID=-1}%2C{WBVAR=}%20%20{NB=KEY1-28}%2C{LINA=KEY1-28}%2C{KT=DUMMY}%2C{OS=28}%2C{K=45}%2C{M=40}%2C{N=36}%2C{S=28}%2C{P=8}%2C{T=7}%2C{Q=4.0}") :set-modified nil :check-read-only nil)
        (oli::sd-attach-item-attribute (oli::sd-pathname-to-obj *ObjectPathName*)  "DEFAULTATTR" :attachment :contents :on-copy :copy :on-xform :maintain :set-modified nil :check-read-only nil  :values '("NN" "Key1" "NB" "KEY1-28" "NBSYN" "KEY1-$OS." "LINA" "KEY1-28" "OS" "28" "K" "45" "M" "40" "N" "36" "S" "28" "P" "8" "T" "7" "Q" "4.0" "SUPPLIER" "NISSEI" "ARTICLENO" "KEY1-28" "BOMINFO" "KEY1-28" "CREATOR" "CADENAS GmbH" ))


        ;;;;;********** Leave Part Parameters Processing **********

        ;;;;;********** Enter Part Color Processing **********

        (oli::set_part_base_color :parts *ObjectPathName* :color :rgb (oli::gpnt3d 0.50196081399918 0.50196081399918 0.50196081399918))

        ;;;;;********** Leave Part Color Processing **********

        ;;;;;********** Enter Part Geometry Processing **********

            ;"Source Sketch Name: Sketch 1"
            (CreateEmptySketch
                "/"
                "PSOL_TEMP_SKETCH"
                (oli::make-gpnt3d :x 0 :y 0 :z 0)
                (oli::make-gpnt3d :x 1 :y 0 :z 0)
                (oli::make-gpnt3d :x 0 :y 0 :z -1)
            )
            (CreateSketchLine -36 -4 0 -4)
            (CreateSketchLine 0 -4 0 4)
            (CreateSketchLine 0 4 -36 4)
            (CreateSketchLine -36 4 -36 -4)
            ;"Source Feature Name: Base extrude 1"
            (CreateExtrudeBase
                *ObjectPathName*
                "PSOL_TEMP_SKETCH"
                7
                :+W
            )

        ;;;;;********** Leave Part Geometry Processing **********

        ;;;;;********** Enter Connection Points Processing **********


        ;;;;;********** Leave Connection Points Processing **********

        ;;;;;********** Enter Surface Color Processing **********


        ;;;;;********** Leave Surface Color Processing **********

        ;;;;;********** Enter Negative Feature Processing **********

        (oli::sd-attach-item-attribute (oli::sd-pathname-to-obj *ObjectPathName*) "PARTsolutions-Negative" :attachment :contents :on-copy :copy :on-xform :maintain :on-merge :detach :values '("IsNegative" "0") :set-modified nil :check-read-only nil)

        ;;;;;********** Leave Negative Feature Processing **********

        ;;;;;********** Enter Physical Properties Processing **********


        (if (not (oli::sd-inq-empty-part-p (oli::sd-pathname-to-obj *ObjectPathName*)))
            (progn
                (oli::assign_mp_data :parcel (oli::sd-pathname-to-obj *ObjectPathName*)
                    :wetted_area (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :area))
                    :solid_volume (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :volume))
                    :centroid (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :centroid))
                    :prin_1 (first (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :principal)))
                    :prin_2 (second (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :principal)))
                    :prin_3 (third (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :principal)))
                    :mmi_1 (oli::gpnt3d_x (first (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :inertia_ref_coord))))
                    :mmi_2 (oli::gpnt3d_y (second (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :inertia_ref_coord))))
                    :mmi_3 (oli::gpnt3d_z (third (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :inertia_ref_coord))))
                )
            )
        )

        ;;;;;********** Leave Physical Properties Processing **********

        ;;;;;********** Enter Document Properties Processing **********

        (aftercreate_6)

        (setq name-in-library (oli::sd-set-library-attr (oli::sd-pathname-to-obj *ObjectPathName*) "PSOL" "KEY1_28"))

        ;;;;;********** Leave Document Properties Processing **********

    )

    ;;;;;**********End PartCreate**********


    (Log 1 "Leave GenerateObject_6")
)

(defun CreateNewPart_6()
    (Log 1 "Enter CreateNewPart_6")
    (GenerateObject_6)
    (Log 1 "Leave CreateNewPart_6")
    (return-from CreateNewPart_6 t)
)

(defun BuildPart_6()
    (Log 2 "Enter BuildPart_6")
    (Log 2 "Part Name:     KEY1_28")
    (Log 2 "Pool Path:     \\10.0.0.236\data_v9/pool/onespacemodeller/")
    (Log 2 "File Name:     KEY1_28")
    (Log 2 "Display Name:  KEY1_28")
    (Log 2 "ObjectPath:    /KEY1_28")

    (OnOpen_6)

	 (if (= *OnOpenValue* 1)
        (progn
            (Log 2 "Loaded Part From Session After OnOpen")
            (Log 2 "Leave BuildPart_6")
	         (return-from BuildPart_6 t)
        )
	 )

	 (if (not (CreateNewPart_6))
		 (progn
			 (Log 4 "Part Creation Failed. Aborting With Fatal Error")
            (Log 2 "Leave BuildPart_6")
			 (return-from BuildPart_6 nil)
		 )
        (progn
            (Log 2 "Part Creation Succeeded")
        )
	 )

	 (beforesave_6)
	 (onsave_6)
	 (aftersave_6)

    (Log 2 "Leave BuildPart_6")
	 (return-from BuildPart_6 t)
)

    ;;;;;********** Enter Part Creation Main "KEY1_28" **********
    (BuildPart_6)
    ;;;;;********** Leave Part Creation Main "KEY1_28" **********

    (transform-document (oli::sd-inq-curr-part) 0 0 0 1 0 0 0 1 0 0 10 100 0 10 101 0 11 100)
        (let
            (
                (volLocal 0)
                (surfaceLocal 0)
                (massLocal 0)
            )
            (if (HasGeometry (oli::sd-pathname-to-obj *ObjectPathName*))
                (progn
                    (setf volLocal (oli::sd-call-cmds (oli::get_vol_prop :for_part (oli::sd-pathname-to-obj *ObjectPathName*) :volume)))
                    (setf surfaceLocal (oli::sd-call-cmds (oli::get_vol_prop :for_part (oli::sd-pathname-to-obj *ObjectPathName*) :area)))
                    (setf massLocal (oli::sd-call-cmds (oli::get_vol_prop :for_part (oli::sd-pathname-to-obj *ObjectPathName*) :mass)))
                )
            )

            (setf volTotal (+ volTotal volLocal))
            (setf surfaceTotal (+ surfaceTotal surfaceLocal))
            (setf massTotal (+ massTotal massLocal))
        )

        (defparameter *ObjectParentName* SAVEPARENT)
        (defparameter *ObjectAsmName* SAVEASM)
        (defparameter *ObjectPathName* SAVEPATH)
    )




        (if (HasGeometry (oli::sd-pathname-to-obj *ObjectPathName*))
            (oli::assign_mp_data :parcel (oli::sd-pathname-to-obj *ObjectPathName*)
                :wetted_area surfaceTotal
                :solid_volume volTotal
                :solid_density (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :xdensity))
                :centroid (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :centroid))
                :prin_1 (first (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :principal)))
                :prin_2 (second (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :principal)))
                :prin_3 (third (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :principal)))
                :mmi_1 (oli::gpnt3d_x (first (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :inertia_ref_coord))))
                :mmi_2 (oli::gpnt3d_y (second (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :inertia_ref_coord))))
                :mmi_3 (oli::gpnt3d_z (third (oli::sd-call-cmds (oli::get_vol_prop :for_part :part_asmb *ObjectPathName* :inertia_ref_coord))))
            )
        )
)
        (defparameter *ObjectPartName* "H2LV_28L_300_T010E")
        (defparameter *ObjectPartModelName* "H2LV_28L_300_T010E")
        (let (old)
            (if (oli::sd-inq-parent-obj (oli::sd-pathname-to-obj *ObjectParentName*))
                (setf old (oli::sd-inq-obj-pathname (oli::sd-inq-parent-obj (oli::sd-pathname-to-obj *ObjectParentName*))))
                (setf old "")
            )

            (oli::change_name_pa :part_asmb *ObjectParentName* :name *ObjectPartModelName* :model_name *ObjectAsmName*)
            (defparameter *ObjectAsmName* *ObjectPartModelName*)
            (defparameter *ObjectPathName* (concatenate 'string old "/" *ObjectPartModelName*))
            (defparameter *ObjectParentName* (oli::sd-inq-obj-basename (oli::sd-pathname-to-obj *ObjectPathName*)))
        )

        (aftercreate_1001)
        (setq name-in-library (oli::sd-set-library-attr (oli::sd-pathname-to-obj *ObjectPathName*) "PSOL" "H2LV_28L_300_T010E"))

    (Log 1 "Leave GenerateObject_1001")
)

    ;;;;;********** Enter Assembly Creation Main "H2LV_28L_300_T010E" **********

    (BuildAssembly_1001)

    ;;;;;********** Leave Assembly Creation Main "H2LV_28L_300_T010E" **********

(Hilite (oli::sd-pathname-to-obj *ObjectPathName*))

;;;;;********** Enter Restore Old Actives **********
(if (not (null *ActiveWorkplane*))
    (oli::current_wp *ActiveWorkplane*)
)

(if (not (null *ActivePart*))
    (oli::current_part *ActivePart*)
)

;;;;;********** Leave Restore Old Actives **********


    (Log 2 (concatenate 'string "Calling Callback " "AppAfterCreate"))
    
    (Log 2 (concatenate 'string "Called Callback " "AppAfterCreate"))



;;;;;********** Begin Reset Global Variables **********

(defparameter *ObjectParentName* "/" "/")
(defparameter *ObjectPathName* "/" "/")
(defparameter *ObjectAsmName* "/" "/")
(defparameter *PartExistsValue* 0)
(defparameter *PartExistsName* nil)
(defparameter *OnOpenValue* 0)
(defparameter *OnOpenName* nil)
(defparameter *OnSaveValue* 0)

;;;;;********** End Reset Global Variables **********

)


(oli::sd-defdialog 'PARTsolutions
    :dialog-title "PARTsolutions Export"
    :toolbox-button nil
    :variables
	 '()
    :local-functions
    '(
        (OnApply()
            (BeginExportLog)
            (oli::sd-call-cmds (CreatePSol))
            (EndExportLog)
            (DisplayExportLog)
        )

        (OnError()
            (EndExportLog)
            (DisplayExportLog)
        )
    )
    :ok-action
	 '(OnApply)
    :exception
    '(OnError)
)


(PARTsolutions)



